/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.domain.OptionInfo;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.rpc.net.LinkType;
import net.hasor.rsf.rpc.net.RsfChannel;
import net.hasor.rsf.rpc.net.SendCallBack;

class RsfChannelOnNetty
extends RsfChannel {
    private final Channel channel;

    RsfChannelOnNetty(InterAddress target, Channel channel, LinkType linkType) {
        super(target, linkType);
        this.channel = channel;
    }

    @Override
    public boolean isActive() {
        return this.channel.isActive();
    }

    @Override
    protected boolean equalsSameAs(RsfChannel rsfChannel) {
        if (rsfChannel instanceof RsfChannelOnNetty) {
            return this.channel.id().asShortText().equals(((RsfChannelOnNetty)rsfChannel).channel.id().asShortText());
        }
        return false;
    }

    @Override
    protected void closeChannel() {
        this.channel.close();
    }

    @Override
    protected void sendData(OptionInfo sendData, SendCallBack sendCallBack) {
        ChannelFuture future = this.channel.writeAndFlush((Object)sendData);
        long requestID = sendData instanceof RequestInfo ? ((RequestInfo)sendData).getRequestID() : (sendData instanceof ResponseInfo ? ((ResponseInfo)sendData).getRequestID() : 0L);
        future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
            if (future1.isSuccess()) {
                if (sendCallBack != null) {
                    sendCallBack.complete(requestID);
                }
                return;
            }
            Object e = null;
            if (future1.isCancelled()) {
                if (sendCallBack != null) {
                    sendCallBack.failed(requestID, new RsfException(0, "user Cancelled."));
                }
            } else if (!future1.isSuccess() && sendCallBack != null) {
                sendCallBack.failed(requestID, future1.cause());
            }
        }));
    }
}

