/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import net.hasor.rsf.domain.OptionInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.rpc.net.RsfChannel;
import net.hasor.rsf.rpc.net.netty.NettyConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettySocketReader
extends ChannelInboundHandlerAdapter {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private NettyConnector connector;

    private static String converToHostProt(ChannelHandlerContext ctx) {
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
    }

    public NettySocketReader(NettyConnector connector) {
        this.connector = connector;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.exceptionCaught(ctx, null);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String hostPort = NettySocketReader.converToHostProt(ctx);
        if (cause == null) {
            this.logger.warn("close socket=" + hostPort + " channel Inactive.");
        } else {
            this.logger.error("close socket=" + hostPort + " with error -> " + cause.getMessage(), cause);
        }
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof OptionInfo) {
            String hostPort = NettySocketReader.converToHostProt(ctx);
            Future<RsfChannel> channel = this.connector.findRsfChannelByHostPort(hostPort);
            if (channel == null || !channel.isDone()) {
                this.exceptionCaught(ctx, new RsfException(600, "the " + hostPort + " connection is not in the pool."));
                return;
            }
            RsfChannel rsfChannel = channel.get();
            if (rsfChannel.getTarget() == null) {
                this.exceptionCaught(ctx, new RsfException(600, "the " + hostPort + " connection is not management."));
                return;
            }
            this.connector.receivedData(rsfChannel, (OptionInfo)msg);
        }
        super.channelRead(ctx, msg);
    }
}

