/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import net.hasor.core.AppContext;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.domain.OptionInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.rpc.net.ConnectionAccepter;
import net.hasor.rsf.rpc.net.Connector;
import net.hasor.rsf.rpc.net.LinkType;
import net.hasor.rsf.rpc.net.ReceivedListener;
import net.hasor.rsf.rpc.net.RsfChannel;
import net.hasor.rsf.rpc.net.netty.NettySocketAccept;
import net.hasor.rsf.rpc.net.netty.NettySocketReader;
import net.hasor.rsf.rpc.net.netty.NettyThreadGroup;
import net.hasor.rsf.rpc.net.netty.ProtocolHandlerFactory;
import net.hasor.rsf.rpc.net.netty.RsfChannelOnNetty;
import net.hasor.utils.future.BasicFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConnector
extends Connector {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private RsfChannel localListener;
    private NettyThreadGroup threadGroup;
    private ProtocolHandlerFactory handlerFactory;
    private AppContext appContext;

    public NettyConnector(String protocol, AppContext appContext, ReceivedListener receivedListener, ConnectionAccepter accepter) throws ClassNotFoundException {
        super(protocol, (RsfEnvironment)appContext.getInstance(RsfEnvironment.class), receivedListener, accepter);
        this.appContext = appContext;
    }

    public EventLoopGroup getWorkerGroup() {
        if (this.threadGroup == null) {
            return null;
        }
        return this.threadGroup.getWorkLoopGroup();
    }

    protected ProtocolHandlerFactory createHandler(String protocol, AppContext appContext) throws ClassNotFoundException {
        String configKey = this.getRsfEnvironment().getSettings().getProtocolConfigKey(protocol);
        String nettyHandlerType = this.getRsfEnvironment().getSettings().getString(configKey + ".nettyHandlerFactory");
        Class<?> handlerClass = appContext.getClassLoader().loadClass(nettyHandlerType);
        return (ProtocolHandlerFactory)appContext.getInstance(handlerClass);
    }

    @Override
    public void startListener(AppContext appContext) throws Throwable {
        this.threadGroup = new NettyThreadGroup(this.getProtocol(), this.getRsfEnvironment());
        this.handlerFactory = this.createHandler(this.getProtocol(), appContext);
        ServerBootstrap boot = new ServerBootstrap();
        boot.group((EventLoopGroup)this.threadGroup.getListenLoopGroup(), this.threadGroup.getWorkLoopGroup());
        boot.channel(NioServerSocketChannel.class);
        boot.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(NettyConnector.this.channelHandlerList());
            }
        });
        boot.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        boot.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture future = this.configBoot(boot).bind((SocketAddress)this.getBindAddress().toSocketAddress());
        BasicFuture result = new BasicFuture();
        future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
            if (!future1.isSuccess()) {
                future1.channel().close();
                result.failed(future1.cause());
            } else {
                Channel channel = future1.channel();
                result.completed((Object)new RsfChannelOnNetty(this.getBindAddress(), channel, LinkType.Listener));
            }
        }));
        try {
            this.localListener = (RsfChannel)result.get();
            this.logger.info("rsf[{}] Server started at {}", (Object)this.getProtocol(), (Object)this.getBindAddress());
        }
        catch (Exception e) {
            this.logger.error("rsf[{}] start listener error: " + e.getMessage(), (Object)this.getProtocol(), (Object)e);
            throw new RsfException(600, this.getBindAddress().toString() + " -> " + e.getMessage());
        }
    }

    private ChannelHandler[] channelHandlerList() {
        ArrayList<ChannelInboundHandlerAdapter> handlers = new ArrayList<ChannelInboundHandlerAdapter>();
        handlers.add(new NettySocketAccept(this));
        handlers.addAll(Arrays.asList(this.handlerFactory.channelHandler(this, this.appContext)));
        handlers.add(new NettySocketReader(this));
        return handlers.toArray(new ChannelHandler[0]);
    }

    @Override
    public void shutdownListener() {
        this.localListener.close();
        this.threadGroup.shutdownGracefully();
    }

    @Override
    public void receivedData(RsfChannel target, OptionInfo object) {
        super.receivedData(target, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionTo(InterAddress hostAddress, BasicFuture<RsfChannel> result) {
        InetSocketAddress inetSocketAddress;
        block5: {
            inetSocketAddress = null;
            try {
                inetSocketAddress = hostAddress.toSocketAddress();
            }
            catch (UnknownHostException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (inetSocketAddress != null) break block5;
                throw new RuntimeException("SocketAddress is null.");
            }
        }
        this.logger.info("connect to {} ...", (Object)hostAddress.toHostSchema());
        Bootstrap boot = new Bootstrap();
        boot.group(this.threadGroup.getWorkLoopGroup());
        boot.channel(NioSocketChannel.class);
        boot.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(NettyConnector.this.channelHandlerList());
            }
        });
        ChannelFuture future = this.configBoot(boot).connect((SocketAddress)inetSocketAddress);
        future.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (!future.isSuccess()) {
                channelFuture.channel().close();
                this.logger.error("connect to {} error.", (Object)hostAddress, (Object)channelFuture.cause());
                result.failed(channelFuture.cause());
            } else {
                Channel channel = channelFuture.channel();
                this.logger.info("connect to {} Success.", (Object)hostAddress);
                RsfChannelOnNetty onNetty = new RsfChannelOnNetty(this.getBindAddress(), channel, LinkType.Out);
                result.completed((Object)this.configListener(onNetty));
            }
        }));
    }

    protected boolean acceptIn(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        if (socketAddress == null) {
            return false;
        }
        String hostAddress = socketAddress.getAddress().getHostAddress();
        int port = socketAddress.getPort();
        String hostPort = hostAddress + ":" + port;
        InterAddress target = new InterAddress(this.getSechma(), hostAddress, port, "unknown");
        RsfChannelOnNetty rsfChannel = new RsfChannelOnNetty(target, ctx.channel(), LinkType.In);
        if (!super.acceptChannel(rsfChannel)) {
            rsfChannel.close();
            this.logger.warn("connection refused form {} ,", (Object)hostPort);
            return false;
        }
        return true;
    }

    private <T extends AbstractBootstrap<?, ?>> T configBoot(T boot) {
        boot.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        boot.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        return boot;
    }
}

