/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.http;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.rsf.rpc.net.http.RsfHttpRequestObject;
import net.hasor.rsf.rpc.net.http.RsfHttpResponse;
import net.hasor.rsf.rpc.net.http.RsfHttpResponseData;
import net.hasor.rsf.utils.IOUtils;

class RsfHttpResponseObject
implements RsfHttpResponse,
RsfHttpResponseData {
    private FullHttpResponse httpResponse;
    private AtomicBoolean committedStatus;

    RsfHttpResponseObject(RsfHttpRequestObject httpRequest) {
        FullHttpRequest nettyRequest = httpRequest.getNettyRequest();
        HttpVersion httpVersion = nettyRequest.protocolVersion();
        HttpResponseStatus status = HttpResponseStatus.OK;
        this.httpResponse = new DefaultFullHttpResponse(httpVersion, status);
        this.committedStatus = new AtomicBoolean(false);
    }

    RsfHttpResponseObject(HttpVersion httpVersion, HttpResponseStatus status) {
        this.httpResponse = new DefaultFullHttpResponse(httpVersion, status);
        this.committedStatus = new AtomicBoolean(false);
    }

    FullHttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    void release() {
        IOUtils.releaseByteBuf((ReferenceCounted)this.httpResponse);
    }

    @Override
    public String getContentType() {
        return this.httpResponse.headers().get("Content-Type");
    }

    @Override
    public void setContentType(String type) {
        this.httpResponse.headers().set("Content-Type", (Object)type);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new ByteBufOutputStream(this.httpResponse.content());
    }

    @Override
    public boolean isCommitted() {
        return this.committedStatus.get();
    }

    @Override
    public void flushBuffer() throws IOException {
        this.committedStatus.set(true);
        int readableBytes = this.httpResponse.content().readableBytes();
        this.setContentLength(readableBytes);
    }

    @Override
    public void setContentLength(long len) {
        this.httpResponse.headers().set("Content-Length", (Object)len);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.httpResponse.setStatus(HttpResponseStatus.parseLine((String)(String.valueOf(sc) + " " + msg)));
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteBufInputStream(this.httpResponse.content());
    }

    @Override
    public int getStatus() {
        if (this.httpResponse.status() != null) {
            return this.httpResponse.status().code();
        }
        return 0;
    }

    @Override
    public String getStatusMessage() {
        if (this.httpResponse.status() != null) {
            return this.httpResponse.status().reasonPhrase();
        }
        return null;
    }

    @Override
    public boolean containsHeader(String name) {
        return this.httpResponse.headers().contains(name);
    }

    @Override
    public void setHeader(String name, String value) {
        this.httpResponse.headers().remove(name);
        this.httpResponse.headers().set(name, (Object)value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.httpResponse.headers().set(name, (Object)value);
    }

    @Override
    public String getHeader(String name) {
        return this.httpResponse.headers().get(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return Collections.unmodifiableCollection(this.httpResponse.headers().getAll(name));
    }

    @Override
    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableCollection(this.httpResponse.headers().names());
    }
}

