/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import net.hasor.rsf.rpc.net.http.RsfHttpResponseObject;
import net.hasor.utils.future.BasicFuture;

class RsfChannelOnHttpClientHandler
extends ChannelInboundHandlerAdapter {
    private RsfHttpResponseObject httpResponse;
    private BasicFuture<RsfHttpResponseObject> responseFuture;

    public RsfChannelOnHttpClientHandler(BasicFuture<RsfHttpResponseObject> responseFuture) {
        this.responseFuture = responseFuture;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.httpResponse = new RsfHttpResponseObject(response.protocolVersion(), response.status());
            return;
        }
        if (msg instanceof LastHttpContent) {
            LastHttpContent http = (LastHttpContent)msg;
            ByteBuf content = http.content();
            this.httpResponse.getHttpResponse().content().writeBytes(content);
            this.responseFuture.completed((Object)this.httpResponse);
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent http = (HttpContent)msg;
            ByteBuf content = http.content();
            this.httpResponse.getHttpResponse().content().writeBytes(content);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.responseFuture.failed(cause);
    }
}

