/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Objects;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.domain.OptionInfo;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.rpc.net.LinkType;
import net.hasor.rsf.rpc.net.RsfChannel;
import net.hasor.rsf.rpc.net.SendCallBack;
import net.hasor.rsf.rpc.net.http.HttpConnector;
import net.hasor.rsf.rpc.net.http.HttpHandler;
import net.hasor.rsf.rpc.net.http.RequestObject;
import net.hasor.rsf.rpc.net.http.RsfChannelOnHttpClientHandler;
import net.hasor.rsf.rpc.net.http.RsfHttpResponseObject;
import net.hasor.rsf.utils.ProtocolUtils;
import net.hasor.utils.future.BasicFuture;

class RsfChannelOnHttp
extends RsfChannel {
    private HttpConnector httpConnector;

    public RsfChannelOnHttp(InterAddress target, LinkType linkType, HttpConnector httpConnector) {
        super(target, linkType);
        this.httpConnector = httpConnector;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void closeChannel() {
    }

    @Override
    protected void sendData(OptionInfo sendData, final SendCallBack sendCallBack) {
        long requestID = sendData instanceof RequestInfo ? ((RequestInfo)sendData).getRequestID() : (sendData instanceof ResponseInfo ? ((ResponseInfo)sendData).getRequestID() : 0L);
        this.sendData(requestID, sendData, new SendCallBack(){

            @Override
            public void failed(long requestID, Throwable e) {
                short status = 500;
                if (e instanceof RsfException) {
                    status = ((RsfException)e).getStatus();
                }
                ResponseInfo responseInfo = ProtocolUtils.buildResponseStatus(null, requestID, status, e.getMessage());
                RsfChannelOnHttp.this.httpConnector.receivedData(RsfChannelOnHttp.this, responseInfo);
                sendCallBack.failed(requestID, e);
            }

            @Override
            public void complete(long requestID) {
                sendCallBack.complete(requestID);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(long requestID, OptionInfo sendData, SendCallBack sendCallBack) {
        if (!(sendData instanceof RequestInfo)) {
            sendCallBack.failed(requestID, new RsfException(500, "only support RequestInfo."));
            return;
        }
        RequestInfo requestInfo = (RequestInfo)sendData;
        URI uri = null;
        try {
            String remoteHost = this.getTarget().getHost();
            int remotePort = this.getTarget().getPort();
            String group = URLEncoder.encode(requestInfo.getServiceGroup(), "UTF-8");
            String name = URLEncoder.encode(requestInfo.getServiceName(), "UTF-8");
            String version = URLEncoder.encode(requestInfo.getServiceVersion(), "UTF-8");
            String pathInfo = String.format("group=%s&name=%s&version=%s", group, name, version);
            uri = new URL("http", remoteHost, remotePort, pathInfo).toURI();
        }
        catch (Exception e) {
            sendCallBack.failed(requestID, e);
            return;
        }
        DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.toASCIIString());
        final ArrayList objectToUse = new ArrayList();
        try {
            HttpHandler.SenderBuilder senderBuilder = new HttpHandler.SenderBuilder(){

                @Override
                public void sendRequest(RequestObject httpRequest, HttpHandler.ResponseDecoder decoder) {
                    Objects.requireNonNull(httpRequest);
                    Objects.requireNonNull(decoder);
                    if (!objectToUse.isEmpty()) {
                        throw new IllegalStateException("sendRequest and finishRequest, have only one of to use");
                    }
                    objectToUse.add(httpRequest);
                    objectToUse.add(decoder);
                }

                @Override
                public void finishRequest(ResponseInfo responseInfo) {
                    Objects.requireNonNull(responseInfo);
                    if (!objectToUse.isEmpty()) {
                        throw new IllegalStateException("sendRequest and finishRequest, have only one of to use");
                    }
                    objectToUse.add(responseInfo);
                }
            };
            this.httpConnector.getHttpHandler().sendRequest(this.getTarget(), requestInfo, senderBuilder);
        }
        catch (Throwable e) {
            sendCallBack.failed(requestID, e);
            return;
        }
        if (objectToUse.isEmpty()) {
            sendCallBack.failed(requestID, new RsfException(500, "the server didn't respond"));
            return;
        }
        Object dat = objectToUse.get(0);
        try {
            if (dat instanceof ResponseInfo && objectToUse.size() == 1) {
                sendCallBack.complete(requestID);
                this.httpConnector.receivedData(this, (ResponseInfo)dat);
                return;
            }
        }
        catch (Exception e) {
            sendCallBack.failed(requestID, e);
            return;
        }
        Channel channel = null;
        final BasicFuture responseFuture = new BasicFuture();
        HttpHandler.ResponseDecoder requestEncoder = (HttpHandler.ResponseDecoder)objectToUse.get(1);
        try {
            RequestObject requestObject = (RequestObject)dat;
            nettyRequest.headers().add(requestObject.headers());
            nettyRequest.setMethod(requestObject.method());
            nettyRequest.headers().set("Connection", (Object)"keep-alive");
            byte[] byteData = requestObject.getBodyData();
            if (byteData != null && byteData.length != 0) {
                nettyRequest.content().writeBytes(byteData);
            }
            nettyRequest.headers().set("Content-Length", (Object)nettyRequest.content().readableBytes());
            URL requestURL = requestObject.requestFullPath();
            if (!"http".equalsIgnoreCase(requestURL.getProtocol())) {
                sendCallBack.failed(requestID, new RsfException(506, "only support HTTP."));
                return;
            }
            String remoteHost = requestURL.getHost();
            int remotePort = requestURL.getPort() <= 0 ? 80 : requestURL.getPort();
            nettyRequest.setUri("http://" + remoteHost + ":" + remotePort + "/" + requestURL.getFile());
            nettyRequest.headers().set("Host", (Object)remoteHost);
            Bootstrap b = new Bootstrap();
            b.group(this.httpConnector.getWorkerGroup());
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpResponseDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new RsfChannelOnHttpClientHandler((BasicFuture<RsfHttpResponseObject>)responseFuture)});
                }
            });
            channel = b.connect(remoteHost, remotePort).sync().channel();
            channel.writeAndFlush((Object)nettyRequest).sync();
        }
        catch (Exception e) {
            sendCallBack.failed(requestID, e);
            this.closeSocket(channel);
            return;
        }
        this.httpConnector.getRsfEnvironment().atTime(timeout -> {
            if (!responseFuture.isDone()) {
                responseFuture.failed((Throwable)new RsfException(408, "client send request failed, request is timeout."));
            }
        }, requestInfo.getClientTimeout());
        try {
            ResponseInfo responseInfo;
            RsfHttpResponseObject responseObject = (RsfHttpResponseObject)responseFuture.get();
            if (!requestInfo.isMessage()) {
                responseInfo = requestEncoder.complete(requestID, responseObject);
                responseObject.release();
                sendCallBack.complete(requestID);
                this.httpConnector.receivedData(this, responseInfo);
            } else {
                responseInfo = ProtocolUtils.buildResponseStatus(null, requestID, (short)102, "ok.");
                this.httpConnector.receivedData(this, responseInfo);
                sendCallBack.complete(requestID);
            }
        }
        catch (Exception e) {
            sendCallBack.failed(requestID, e);
        }
        finally {
            this.closeSocket(channel);
        }
    }

    void closeSocket(Channel channel) {
        if (channel == null) {
            return;
        }
        try {
            channel.close().sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

