/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.http;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.hasor.rsf.rpc.net.http.RequestObject;

public class RequestBuilder {
    private URL httpRequest;
    private String httpMethod;
    private HttpHeaders headers;
    private byte[] contentData;

    private RequestBuilder(URL httpRequest, String httpMethod) {
        this.httpRequest = httpRequest;
        this.httpMethod = httpMethod;
        this.headers = new DefaultHttpHeaders();
    }

    public static RequestBuilder newBuild(String httpMethod, URL httpRequest) {
        return new RequestBuilder(httpRequest, httpMethod);
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public void setContentData(byte[] contentData) {
        this.contentData = contentData;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, String value) {
        this.headers.remove(name);
        this.headers.set(name, (Object)value);
    }

    public void addHeader(String name, String value) {
        this.headers.add(name, (Object)value);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public void setHeaderValues(String name, List<String> valueList) {
        if (valueList == null) {
            // empty if block
        }
        this.headers.remove(name);
        this.headers.set(name, valueList.iterator());
    }

    public List<String> getHeaders(String name) {
        return Collections.unmodifiableList(this.headers.getAll(name));
    }

    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.names());
    }

    public RequestObject buildObject() {
        return new RequestObject(HttpMethod.valueOf((String)this.httpMethod), this.headers, this.httpRequest, this.contentData);
    }
}

