/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.http;

import net.hasor.core.AppContext;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.rpc.net.ConnectionAccepter;
import net.hasor.rsf.rpc.net.LinkType;
import net.hasor.rsf.rpc.net.ReceivedListener;
import net.hasor.rsf.rpc.net.RsfChannel;
import net.hasor.rsf.rpc.net.http.HttpHandler;
import net.hasor.rsf.rpc.net.http.HttpHandlerFactory;
import net.hasor.rsf.rpc.net.http.HttpProtocolHandler;
import net.hasor.rsf.rpc.net.http.RsfChannelOnHttp;
import net.hasor.rsf.rpc.net.netty.NettyConnector;
import net.hasor.rsf.rpc.net.netty.ProtocolHandlerFactory;
import net.hasor.utils.future.BasicFuture;

public class HttpConnector
extends NettyConnector {
    private HttpHandler httpHandler;

    public HttpConnector(String protocol, AppContext appContext, ReceivedListener receivedListener, ConnectionAccepter accepter) throws ClassNotFoundException {
        super(protocol, appContext, receivedListener, accepter);
    }

    protected HttpHandler getHttpHandler() {
        return this.httpHandler;
    }

    @Override
    public void startListener(AppContext appContext) throws Throwable {
        String configKey = this.getRsfEnvironment().getSettings().getProtocolConfigKey(this.getProtocol());
        String httpHandlerFactory = this.getRsfEnvironment().getSettings().getString(configKey + ".httpHandlerFactory");
        String contextPath = this.getRsfEnvironment().getSettings().getString(configKey + ".contextPath");
        Class<?> handlerClass = appContext.getClassLoader().loadClass(httpHandlerFactory);
        this.httpHandler = ((HttpHandlerFactory)appContext.getInstance(handlerClass)).newHandler(contextPath, this, appContext);
        super.startListener(appContext);
    }

    @Override
    public void shutdownListener() {
        this.httpHandler = null;
        super.shutdownListener();
    }

    @Override
    protected ProtocolHandlerFactory createHandler(String protocol, AppContext appContext) throws ClassNotFoundException {
        return new HttpProtocolHandler(this.httpHandler);
    }

    @Override
    public void connectionTo(InterAddress hostAddress, BasicFuture<RsfChannel> channelFuture) {
        this.logger.info("connect to {} ...", (Object)hostAddress.toHostSchema());
        RsfChannelOnHttp channel = new RsfChannelOnHttp(hostAddress, LinkType.Out, this);
        channelFuture.completed((Object)channel);
        super.configListener(channel);
    }
}

