/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCounted;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.rpc.net.Connector;
import net.hasor.rsf.rpc.net.http.HttpHandler;
import net.hasor.rsf.rpc.net.http.RsfHttpRequestObject;
import net.hasor.rsf.rpc.net.http.RsfHttpResponseObject;
import net.hasor.rsf.rpc.net.http.WorkStatus;
import net.hasor.rsf.utils.IOUtils;
import net.hasor.rsf.utils.ProtocolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCoder
extends ChannelDuplexHandler {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private WorkStatus workStatus;
    private RsfContext rsfContext;
    private HttpHandler httpHandler;
    private Connector connector;
    private RsfHttpRequestObject httpRequest;
    private RsfHttpResponseObject httpResponse;
    private HttpHandler.ResponseEncoder encoder;

    public HttpCoder(RsfContext rsfContext, Connector connector, HttpHandler httpHandler) {
        this.rsfContext = rsfContext;
        this.connector = connector;
        this.httpHandler = httpHandler;
        this.workStatus = WorkStatus.Idle;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.httpRequest != null) {
            this.httpRequest.release();
        }
        if (this.httpResponse != null) {
            this.httpResponse.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ReferenceCounted referenceCounted = null;
        try {
            if (msg instanceof ReferenceCounted) {
                referenceCounted = (ReferenceCounted)msg;
            }
            this.readData(ctx, msg);
        }
        catch (Throwable e) {
            try {
                this.exceptionCaught(ctx, e);
            }
            catch (Throwable throwable) {
                IOUtils.releaseByteBuf(referenceCounted);
                throw throwable;
            }
            IOUtils.releaseByteBuf(referenceCounted);
        }
        IOUtils.releaseByteBuf(referenceCounted);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        int errorCode = HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
        String errorMessage = HttpResponseStatus.INTERNAL_SERVER_ERROR.reasonPhrase();
        if (e instanceof RsfException) {
            errorCode = ((RsfException)e).getStatus();
            errorMessage = e.getMessage();
        }
        FullHttpResponse httpResponse = null;
        if (this.httpResponse == null) {
            HttpVersion version = this.httpRequest != null ? this.httpRequest.getNettyRequest().protocolVersion() : HttpVersion.HTTP_1_1;
            HttpResponseStatus status = HttpResponseStatus.parseLine((String)(errorCode + " " + errorMessage));
            new DefaultFullHttpResponse(version, status);
            this.httpResponse = new RsfHttpResponseObject(version, status);
        } else {
            this.httpResponse.sendError(errorCode, errorMessage);
        }
        if (this.encoder != null) {
            try {
                this.encoder.exception(this.httpResponse, e);
            }
            catch (Exception ee) {
                this.logger.error(ee.getMessage(), (Throwable)ee);
            }
        }
        httpResponse = this.httpResponse.getHttpResponse();
        ctx.writeAndFlush((Object)httpResponse).channel().close().sync();
    }

    private void readData(ChannelHandlerContext ctx, Object msg) throws Throwable {
        if (msg instanceof HttpRequest) {
            HttpVersion httpVersion = ((HttpRequest)msg).protocolVersion();
            HttpMethod httpMethod = ((HttpRequest)msg).method();
            String requestURI = ((HttpRequest)msg).uri();
            InetSocketAddress remoteSocket = (InetSocketAddress)ctx.channel().remoteAddress();
            InterAddress remoteAddress = new InterAddress("socket", remoteSocket.getAddress().getHostAddress(), remoteSocket.getPort(), "unknown");
            InterAddress local = this.connector.getBindAddress();
            this.httpRequest = new RsfHttpRequestObject(remoteAddress, local, (FullHttpRequest)new DefaultFullHttpRequest(httpVersion, httpMethod, requestURI));
            this.httpResponse = new RsfHttpResponseObject(this.httpRequest);
            this.workStatus = WorkStatus.ReceiveRequest;
            this.httpRequest.getNettyRequest().headers().set(((HttpRequest)msg).headers());
            return;
        }
        if (msg instanceof LastHttpContent) {
            ByteBuf content = ((LastHttpContent)msg).content();
            this.httpRequest.getNettyRequest().content().writeBytes(content);
            if (HttpMethod.POST.equals((Object)this.httpRequest.getNettyRequest().method())) {
                this.httpRequest.loadPostRequestBody();
            }
            this.doInvoker(ctx);
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent http = (HttpContent)msg;
            ByteBuf content = http.content();
            this.httpRequest.getNettyRequest().content().writeBytes(content);
            return;
        }
        super.channelRead(ctx, msg);
    }

    private void doInvoker(final ChannelHandlerContext ctx) throws Throwable {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        HttpHandler.HttpResult httpResult = new HttpHandler.HttpResult(){

            @Override
            public void callRPC(RequestInfo requestInfo, HttpHandler.ResponseEncoder encoder) {
                Objects.requireNonNull(requestInfo);
                Objects.requireNonNull(encoder);
                if (atomicBoolean.get()) {
                    throw new IllegalStateException("callRPC and finishRPC , have only one of to use");
                }
                HttpCoder.this.httpRequest.setRsfRequest(requestInfo);
                HttpCoder.this.encoder = encoder;
                atomicBoolean.set(true);
            }

            @Override
            public void finishRPC() {
                if (atomicBoolean.get()) {
                    throw new IllegalStateException("callRPC and finishRPC , have only one of to use");
                }
                atomicBoolean.set(true);
            }
        };
        this.httpHandler.receivedRequest(this.httpRequest, this.httpResponse, httpResult);
        if (!atomicBoolean.get()) {
            if (this.httpResponse.getStatus() == 0) {
                this.httpResponse.sendError(500, "the server didn't respond");
            }
            this.write(ctx, this.httpResponse.getHttpResponse(), null);
            return;
        }
        if (this.httpResponse.isCommitted()) {
            this.write(ctx, this.httpResponse.getHttpResponse(), null);
            return;
        }
        RequestInfo rsfRequest = this.httpRequest.getRsfRequest();
        if (rsfRequest != null) {
            this.rsfContext.getEnvironment().atTime(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    if (ctx.channel().isActive()) {
                        HttpCoder.this.exceptionCaught(ctx, new RsfException(408, "request timeout."));
                    }
                }
            }, this.rsfContext.getEnvironment().getSettings().getRequestTimeout());
            ctx.fireChannelRead((Object)rsfRequest);
            return;
        }
        ResponseInfo info = ProtocolUtils.buildResponseStatus(this.rsfContext.getEnvironment(), 0L, (short)506, "request has no invoker.");
        this.write(ctx, info, null);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ResponseInfo) {
            ResponseInfo response = (ResponseInfo)msg;
            if (response.getStatus() == 102) {
                return;
            }
            if (this.encoder != null) {
                this.encoder.complete(this.httpResponse, response);
            }
            msg = this.httpResponse.getHttpResponse();
        }
        if (msg instanceof FullHttpResponse) {
            ctx.writeAndFlush(msg).sync().channel().close().sync();
            return;
        }
        super.write(ctx, msg, promise);
    }
}

