/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.rpc.net.RsfChannel;
import net.hasor.utils.future.BasicFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkPool {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final RsfEnvironment environment;
    private final ConcurrentMap<String, BasicFuture<RsfChannel>> channelMap;

    public LinkPool(RsfEnvironment environment) {
        this.environment = environment;
        this.channelMap = new ConcurrentHashMap<String, BasicFuture<RsfChannel>>();
    }

    public void initPool() {
        if (this.inited.compareAndSet(false, true)) {
            this.logger.info("init LinkPool.");
        }
    }

    public void destroyPool() {
        if (this.inited.compareAndSet(true, false)) {
            this.logger.info("destroy LinkPool.");
            for (BasicFuture future : this.channelMap.values()) {
                if (future == null) continue;
                if (!future.isDone()) {
                    future.failed((Throwable)new IllegalStateException("the pool destroy."));
                    continue;
                }
                try {
                    ((RsfChannel)future.get()).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized BasicFuture<RsfChannel> preConnection(String hostPortKey) {
        if (!this.inited.get()) {
            throw new IllegalStateException("LinkPool not inited.");
        }
        final BasicFuture channel = new BasicFuture();
        BasicFuture<RsfChannel> oldFuture = this.channelMap.putIfAbsent(hostPortKey, (BasicFuture<RsfChannel>)channel);
        if (oldFuture != null) {
            return oldFuture;
        }
        int timeout = this.environment.getSettings().getConnectTimeout();
        this.environment.atTime(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (!channel.isDone()) {
                    channel.failed((Throwable)new RsfException(408, "connection not ready within the given time."));
                }
            }
        }, timeout);
        return channel;
    }

    public void closeConnection(String hostPortKey) {
        BasicFuture<RsfChannel> future = this.findChannel(hostPortKey);
        if (future == null) {
            return;
        }
        this.channelMap.remove(hostPortKey);
        if (future.isDone()) {
            try {
                ((RsfChannel)future.get()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void mappingTo(RsfChannel rsfChannel, String hostPort) {
    }

    public BasicFuture<RsfChannel> findChannel(String hostPortKey) {
        return (BasicFuture)this.channelMap.get(hostPortKey);
    }
}

