/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net;

import java.net.UnknownHostException;
import java.util.concurrent.Future;
import net.hasor.core.AppContext;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.domain.OptionInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.rpc.net.CloseListener;
import net.hasor.rsf.rpc.net.ConnectionAccepter;
import net.hasor.rsf.rpc.net.LinkPool;
import net.hasor.rsf.rpc.net.ReceivedListener;
import net.hasor.rsf.rpc.net.RsfChannel;
import net.hasor.utils.future.BasicFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Connector {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String protocol;
    private final String sechma;
    private final RsfEnvironment rsfEnvironment;
    private final InterAddress bindAddress;
    private final LinkPool linkPool;
    private final ReceivedListener receivedListener;
    private final ConnectionAccepter accepter;

    public Connector(String protocol, RsfEnvironment rsfEnvironment, ReceivedListener receivedListener, ConnectionAccepter accepter) {
        this.protocol = protocol;
        this.rsfEnvironment = rsfEnvironment;
        this.linkPool = new LinkPool(rsfEnvironment);
        this.linkPool.initPool();
        this.receivedListener = receivedListener;
        this.accepter = accepter;
        RsfSettings settings = rsfEnvironment.getSettings();
        String configKey = settings.getProtocolConfigKey(protocol);
        this.sechma = settings.getString(configKey + ".protocol");
        this.bindAddress = settings.getBindAddressSet(protocol);
        if (this.bindAddress.getPort() <= 0) {
            throw new IllegalStateException("[" + protocol + "] the prot is zero.");
        }
    }

    public String toString() {
        return "Connector{ protocol='" + this.protocol + "', bindAddress=" + this.bindAddress + '}';
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSechma() {
        return this.sechma;
    }

    public RsfEnvironment getRsfEnvironment() {
        return this.rsfEnvironment;
    }

    public InterAddress getBindAddress() {
        return this.bindAddress;
    }

    public Future<RsfChannel> findRsfChannelByHostPort(String hostPort) {
        return this.linkPool.findChannel(hostPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RsfChannel> getOrConnectionTo(InterAddress target) throws UnknownHostException {
        String protocol = target.getSechma();
        if (!this.sechma.equalsIgnoreCase(protocol)) {
            throw new RsfException(506, "sechma not match.");
        }
        String hostPort = target.getIpPort();
        BasicFuture<RsfChannel> channelFuture = this.linkPool.findChannel(hostPort);
        if (channelFuture != null && channelFuture.isDone()) {
            RsfChannel channel = null;
            try {
                channel = (RsfChannel)channelFuture.get();
                if (channel != null && !channel.isActive()) {
                    this.linkPool.closeConnection(hostPort);
                    channelFuture = null;
                }
            }
            catch (Exception e) {
                this.linkPool.closeConnection(hostPort);
                channelFuture = null;
            }
        }
        if (channelFuture != null) {
            return channelFuture;
        }
        Connector connector = this;
        synchronized (connector) {
            channelFuture = this.linkPool.findChannel(hostPort);
            if (channelFuture != null) {
                return channelFuture;
            }
            channelFuture = this.linkPool.preConnection(hostPort);
            this.logger.info("connect to {} ...", (Object)hostPort);
            this.connectionTo(target, channelFuture);
        }
        return channelFuture;
    }

    protected RsfChannel configListener(RsfChannel rsfChannel) {
        rsfChannel.addListener(this.receivedListener);
        rsfChannel.onClose(new CloseListener(this.linkPool));
        return rsfChannel;
    }

    protected boolean acceptChannel(RsfChannel rsfChannel) throws Exception {
        if (this.accepter.acceptIn(rsfChannel)) {
            String hostPort = rsfChannel.getTarget().getHostPort();
            BasicFuture<RsfChannel> future = this.linkPool.preConnection(hostPort);
            if (!future.isDone()) {
                future.completed((Object)rsfChannel);
            }
            if (rsfChannel.equalsSameAs((RsfChannel)future.get())) {
                this.configListener(rsfChannel);
                return true;
            }
            return true;
        }
        this.logger.warn("connection[{}] refused form {} ,", (Object)this.getProtocol(), (Object)rsfChannel.getTarget().getHostPort());
        return false;
    }

    public final void shutdown() {
        this.shutdownListener();
        this.linkPool.destroyPool();
    }

    public abstract void startListener(AppContext var1) throws Throwable;

    public abstract void shutdownListener();

    protected void receivedData(RsfChannel rsfChannel, OptionInfo object) {
        rsfChannel.receivedData(object);
    }

    protected abstract void connectionTo(InterAddress var1, BasicFuture<RsfChannel> var2);
}

