/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.context;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.hasor.core.Settings;
import net.hasor.core.XmlNode;
import net.hasor.core.setting.SettingsWrap;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfOptionSet;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.SendLimitPolicy;
import net.hasor.rsf.domain.OptionInfo;
import net.hasor.rsf.utils.NetworkUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRsfSettings
extends SettingsWrap
implements RsfSettings {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private int defaultTimeout = 6000;
    private String defaultGroup = "RSF";
    private String defaultVersion = "1.0.0";
    private String defaultSerializeType = "Hprose";
    private OptionInfo serverOptionManager = new OptionInfo();
    private OptionInfo clientOptionManager = new OptionInfo();
    private int queueMaxSize = 4096;
    private int queueMinPoolSize = 1;
    private int queueMaxPoolSize = 7;
    private long queueKeepAliveTime = 300L;
    private String bindAddress = "local";
    private String defaultProtocol = null;
    private Map<String, String> connectorSet = null;
    private Map<String, InterAddress> bindAddressSet = null;
    private int requestTimeout = 6000;
    private int maximumRequest = 200;
    private SendLimitPolicy sendLimitPolicy = SendLimitPolicy.Reject;
    private int connectTimeout = 100;
    private String unitName = "default";
    private long invalidWaitTime = 30000L;
    private long refreshCacheTime = 360000L;
    private boolean localDiskCache = true;
    private long diskCacheTimeInterval = 3600000L;
    private boolean automaticOnline = true;

    public DefaultRsfSettings(Settings settings) throws IOException {
        super(settings);
        this.refreshRsfConfig();
    }

    @Override
    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public RsfOptionSet getServerOption() {
        return this.serverOptionManager;
    }

    @Override
    public RsfOptionSet getClientOption() {
        return this.clientOptionManager;
    }

    @Override
    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    @Override
    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public String getDefaultSerializeType() {
        return this.defaultSerializeType;
    }

    @Override
    public int getQueueMaxSize() {
        return this.queueMaxSize;
    }

    @Override
    public int getQueueMinPoolSize() {
        return this.queueMinPoolSize;
    }

    @Override
    public int getQueueMaxPoolSize() {
        return this.queueMaxPoolSize;
    }

    @Override
    public long getQueueKeepAliveTime() {
        return this.queueKeepAliveTime;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public int getMaximumRequest() {
        return this.maximumRequest;
    }

    @Override
    public SendLimitPolicy getSendLimitPolicy() {
        return this.sendLimitPolicy;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    @Override
    public Set<String> getProtocos() {
        return Collections.unmodifiableSet(this.connectorSet.keySet());
    }

    @Override
    public InterAddress getBindAddressSet(String protocolName) {
        return this.bindAddressSet.get(protocolName);
    }

    @Override
    public String getProtocolConfigKey(String protocolName) {
        return this.connectorSet.get(protocolName);
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    @Override
    public long getInvalidWaitTime() {
        return this.invalidWaitTime;
    }

    @Override
    public long getRefreshCacheTime() {
        return this.refreshCacheTime;
    }

    @Override
    public long getDiskCacheTimeInterval() {
        return this.diskCacheTimeInterval;
    }

    @Override
    public boolean islocalDiskCache() {
        return this.localDiskCache;
    }

    @Override
    public boolean isAutomaticOnline() {
        return this.automaticOnline;
    }

    public void refresh() throws IOException {
        super.refresh();
        this.refreshRsfConfig();
    }

    @Override
    public void refreshRsfConfig() throws IOException {
        XmlNode[] clientOptSetArray;
        this.defaultGroup = this.getString("hasor.rsfConfig.defaultServiceValue.group", "RSF");
        this.defaultVersion = this.getString("hasor.rsfConfig.defaultServiceValue.version", "1.0.0");
        this.defaultTimeout = this.getInteger("hasor.rsfConfig.defaultServiceValue.timeout", 6000);
        this.defaultSerializeType = this.getString("hasor.rsfConfig.serializeType.default", "Hessian");
        XmlNode[] serverOptSetArray = this.getXmlNodeArray("hasor.rsfConfig.serverOptionSet");
        if (serverOptSetArray != null) {
            for (XmlNode optSet : serverOptSetArray) {
                for (XmlNode opt : optSet.getChildren("option")) {
                    String key = opt.getAttribute("key");
                    String var = opt.getText();
                    if (StringUtils.isBlank((String)key)) continue;
                    this.serverOptionManager.addOption(key, var);
                }
            }
        }
        if ((clientOptSetArray = this.getXmlNodeArray("hasor.rsfConfig.clientOptionSet")) != null) {
            for (XmlNode optSet : clientOptSetArray) {
                for (XmlNode opt : optSet.getChildren("option")) {
                    String key = opt.getAttribute("key");
                    String var = opt.getText();
                    if (StringUtils.isBlank((String)key)) continue;
                    this.clientOptionManager.addOption(key, var);
                }
            }
        }
        this.queueMaxSize = this.getInteger("hasor.rsfConfig.queue.maxSize", 4096);
        this.queueMinPoolSize = this.getInteger("hasor.rsfConfig.queue.minPoolSize", 1);
        this.queueMaxPoolSize = this.getInteger("hasor.rsfConfig.queue.maxPoolSize", 7);
        this.queueKeepAliveTime = this.getLong("hasor.rsfConfig.queue.keepAliveTime", 300L);
        String bindAddress = this.getString("hasor.rsfConfig.address", "local");
        InetAddress inetAddress = NetworkUtils.finalBindAddress(bindAddress);
        this.bindAddress = inetAddress.getHostAddress();
        this.bindAddressSet = new HashMap<String, InterAddress>();
        HashMap<String, String> connectorTmpSet = new HashMap<String, String>();
        XmlNode[] connectorRoot = this.getXmlNodeArray("hasor.rsfConfig.connectorSet");
        if (connectorRoot != null) {
            for (XmlNode connectorSet : connectorRoot) {
                if (connectorSet == null || connectorSet.getChildren().isEmpty()) continue;
                for (XmlNode connector : connectorSet.getChildren()) {
                    connectorTmpSet.put(connector.getName(), "hasor.rsfConfig.connectorSet." + connector.getName());
                }
            }
        }
        this.connectorSet = new HashMap<String, String>();
        for (String connectorName : connectorTmpSet.keySet()) {
            String basePath = (String)connectorTmpSet.get(connectorName);
            String name = this.getString(basePath + ".name");
            String protocol = this.getString(basePath + ".protocol");
            if (StringUtils.isBlank((String)protocol) || StringUtils.isBlank((String)name)) continue;
            if (this.connectorSet.containsKey(name)) {
                throw new IOException("repeat connector config error , name is " + name);
            }
            int localPort = this.getInteger(basePath + ".localPort", 0);
            if (localPort <= 0) continue;
            InterAddress localAddress = new InterAddress(protocol, this.bindAddress, localPort, this.unitName);
            this.connectorSet.put(name, basePath);
            this.bindAddressSet.put(name, localAddress);
        }
        this.defaultProtocol = this.getString("hasor.rsfConfig.connectorSet.default");
        if (!this.bindAddressSet.containsKey(this.defaultProtocol)) {
            throw new IOException("default protocol missing config.");
        }
        this.requestTimeout = this.getInteger("hasor.rsfConfig.client.defaultTimeout", 6000);
        this.maximumRequest = this.getInteger("hasor.rsfConfig.client.maximumRequest", 200);
        this.sendLimitPolicy = (SendLimitPolicy)this.getEnum("hasor.rsfConfig.client.sendLimitPolicy", SendLimitPolicy.class, SendLimitPolicy.Reject);
        this.connectTimeout = this.getInteger("hasor.rsfConfig.client.connectTimeout", 100);
        this.unitName = this.getString("hasor.rsfConfig.unitName", "local");
        this.refreshCacheTime = this.getLong("hasor.rsfConfig.addressPool.refreshCacheTime", 60000L);
        this.invalidWaitTime = this.getLong("hasor.rsfConfig.addressPool.invalidWaitTime", 120000L);
        this.localDiskCache = this.getBoolean("hasor.rsfConfig.addressPool.localDiskCache", true);
        this.diskCacheTimeInterval = this.getLong("hasor.rsfConfig.addressPool.diskCacheTimeInterval", 3600000L);
        this.automaticOnline = this.getBoolean("hasor.rsfConfig.automaticOnline", true);
        this.logger.info("loadRsfConfig complete!");
    }
}

