/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.context;

import io.netty.util.TimerTask;
import java.io.IOException;
import java.util.UUID;
import net.hasor.core.Environment;
import net.hasor.core.environment.EnvironmentWrap;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.SerializeCoder;
import net.hasor.rsf.rpc.context.DefaultRsfSettings;
import net.hasor.rsf.serialize.SerializeFactory;
import net.hasor.rsf.utils.TimerManager;

public class DefaultRsfEnvironment
extends EnvironmentWrap
implements RsfEnvironment {
    private RsfSettings rsfSettings = null;
    private SerializeFactory factory = null;
    private TimerManager timerManager = null;
    private String instanceID = UUID.randomUUID().toString().replace("-", "");

    public DefaultRsfEnvironment(Environment environment) throws IOException {
        super(environment);
        this.rsfSettings = new DefaultRsfSettings(environment.getSettings());
        this.factory = SerializeFactory.createFactory(this);
        int connectTimeout = this.rsfSettings.getConnectTimeout();
        this.timerManager = new TimerManager(connectTimeout, "RSF-Timer", environment.getClassLoader());
    }

    @Override
    public RsfSettings getSettings() {
        return this.rsfSettings;
    }

    @Override
    public SerializeCoder getSerializeCoder(String codeName) {
        return this.factory.getSerializeCoder(codeName);
    }

    @Override
    public void atTime(TimerTask timeTask, int timeout) {
        this.timerManager.atTime(timeTask, timeout);
    }

    @Override
    public void atTime(TimerTask timerTask) {
        this.timerManager.atTime(timerTask);
    }

    @Override
    public String getInstanceID() {
        return this.instanceID;
    }
}

