/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.context;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.hasor.core.AppContext;
import net.hasor.core.EventContext;
import net.hasor.core.spi.ContextShutdownListener;
import net.hasor.core.spi.ContextStartListener;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfClient;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfPublisher;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.RsfUpdater;
import net.hasor.rsf.address.DiskCacheAddressPool;
import net.hasor.rsf.container.RsfBeanContainer;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.domain.provider.InstanceAddressProvider;
import net.hasor.rsf.domain.provider.PoolAddressProvider;
import net.hasor.rsf.rpc.caller.SenderListener;
import net.hasor.rsf.rpc.caller.remote.RemoteRsfCaller;
import net.hasor.rsf.rpc.client.RpcRsfClient;
import net.hasor.rsf.rpc.net.Connector;
import net.hasor.rsf.rpc.net.ReceivedAdapter;
import net.hasor.rsf.rpc.net.RsfChannel;
import net.hasor.rsf.rpc.net.RsfNetManager;
import net.hasor.rsf.rpc.net.SendCallBack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRsfContext
implements RsfContext,
ContextStartListener,
ContextShutdownListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RsfBeanContainer rsfBeanContainer;
    private final RsfEnvironment rsfEnvironment;
    private final RemoteRsfCaller rsfCaller;
    private final RsfNetManager rsfNetManager;
    private final DiskCacheAddressPool addressPool;
    private final PoolAddressProvider poolProvider;
    private final AtomicBoolean onlineStatus;
    private AppContext appContext;

    public AbstractRsfContext(RsfEnvironment rsfEnvironment) {
        this.addressPool = new DiskCacheAddressPool(rsfEnvironment);
        this.poolProvider = new PoolAddressProvider(this.addressPool);
        this.rsfBeanContainer = new RsfBeanContainer(this.addressPool);
        this.rsfEnvironment = rsfEnvironment;
        Transport transport = new Transport();
        this.rsfNetManager = new RsfNetManager(rsfEnvironment, transport);
        this.rsfCaller = new RemoteRsfCaller(this, this.rsfBeanContainer, transport);
        this.onlineStatus = new AtomicBoolean(false);
    }

    public synchronized void doStart(AppContext appContext) {
        boolean enable = this.rsfEnvironment.getSettings().getBoolean("hasor.rsfConfig.enable", false);
        if (!enable) {
            this.logger.info("rsf framework disable -> 'hasor.rsfConfig.enable' is false");
            return;
        }
        this.appContext = appContext;
        this.logger.info("rsfContext -> doStart , lookUp services for loadModule phase.");
        this.rsfBeanContainer.lookUp(appContext);
        this.rsfNetManager.start(appContext);
        Set<String> protocols = this.rsfNetManager.runProtocols();
        if (protocols == null || protocols.isEmpty()) {
            throw new IllegalStateException("not running any protocol, please check the configuration.");
        }
        for (String protocol : protocols) {
            InterAddress interAddress = this.bindAddress(protocol);
            this.logger.info("rsfContext -> doStart , bindAddress : {}", (Object)interAddress.toHostSchema());
        }
    }

    public void doStartCompleted(AppContext appContext) {
        this.addressPool.restoreConfig();
        this.addressPool.startTimer();
        if (this.rsfEnvironment.getSettings().isAutomaticOnline()) {
            this.online();
        }
        this.logger.info("rsf framework started.");
    }

    public void doShutdown(AppContext appContext) {
        this.logger.info("rsf framework shutdown.");
        this.offline();
        this.rsfCaller.shutdown();
        this.rsfNetManager.shutdown();
        this.addressPool.shutdownTimer();
    }

    public void doShutdownCompleted(AppContext appContext) {
    }

    @Override
    public synchronized void online() {
        if (!this.onlineStatus.compareAndSet(false, true)) {
            this.logger.error("rsfContext -> already online");
            return;
        }
        this.logger.info("rsfContext -> already online , fireSyncEvent ,eventType = {}", (Object)"RsfEvent_Online");
        EventContext ec = this.getAppContext().getEnvironment().getEventContext();
        try {
            ec.fireSyncEvent("RsfEvent_Online", (Object)this);
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void offline() {
        if (!this.onlineStatus.compareAndSet(true, false)) {
            this.logger.error("rsfContext -> already offline");
            return;
        }
        this.logger.info("rsfContext -> already offline , fireSyncEvent ,eventType = {}", (Object)"RsfEvent_Online");
        EventContext ec = this.getAppContext().getEnvironment().getEventContext();
        try {
            ec.fireSyncEvent("RsfEvent_Offline", (Object)this);
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    @Override
    public boolean isOnline() {
        return this.onlineStatus.get();
    }

    @Override
    public String getInstanceID() {
        return this.rsfEnvironment.getInstanceID();
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext;
    }

    @Override
    public Set<String> runProtocols() {
        return this.rsfNetManager.runProtocols();
    }

    @Override
    public String getDefaultProtocol() {
        return this.rsfEnvironment.getSettings().getDefaultProtocol();
    }

    @Override
    public RsfEnvironment getEnvironment() {
        return this.rsfEnvironment;
    }

    @Override
    public RsfSettings getSettings() {
        return this.rsfEnvironment.getSettings();
    }

    @Override
    public RsfUpdater getUpdater() {
        return this.addressPool;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.rsfEnvironment.getClassLoader();
    }

    @Override
    public InterAddress bindAddress(String protocol) {
        Connector connector = this.rsfNetManager.findConnector(protocol);
        if (connector == null) {
            return null;
        }
        return connector.getBindAddress();
    }

    @Override
    public RsfClient getRsfClient() {
        return new RpcRsfClient(this.poolProvider, this.rsfCaller);
    }

    @Override
    public RsfClient getRsfClient(String targetStr) throws URISyntaxException, UnknownHostException {
        return this.getRsfClient(new InterAddress(targetStr));
    }

    @Override
    public RsfClient getRsfClient(URI targetURL) throws UnknownHostException {
        return this.getRsfClient(new InterAddress(targetURL));
    }

    @Override
    public RsfClient getRsfClient(InterAddress target) {
        InstanceAddressProvider provider = new InstanceAddressProvider(target);
        return new RpcRsfClient(provider, this.rsfCaller);
    }

    @Override
    public <T> RsfBindInfo<T> getServiceInfo(String serviceID) {
        return this.rsfBeanContainer.getRsfBindInfo(serviceID);
    }

    @Override
    public <T> RsfBindInfo<T> getServiceInfo(String aliasType, String aliasName) {
        return this.rsfBeanContainer.getRsfBindInfo(aliasType, aliasName);
    }

    @Override
    public <T> RsfBindInfo<T> getServiceInfo(Class<T> serviceType) {
        return this.rsfBeanContainer.getRsfBindInfo(serviceType);
    }

    @Override
    public <T> RsfBindInfo<T> getServiceInfo(String group, String name, String version) {
        return this.rsfBeanContainer.getRsfBindInfo(group, name, version);
    }

    @Override
    public List<String> getServiceIDs() {
        return this.rsfBeanContainer.getServiceIDs();
    }

    @Override
    public List<String> getServiceIDs(String aliasType) {
        return this.rsfBeanContainer.getServiceIDs(aliasType);
    }

    @Override
    public <T> Supplier<T> getServiceProvider(RsfBindInfo<T> bindInfo) {
        return this.rsfBeanContainer.getProvider(bindInfo);
    }

    @Override
    public RsfPublisher publisher() {
        return this.rsfBeanContainer.createPublisher(this.rsfBeanContainer, this);
    }

    private Connector findConnector(InterAddress target) {
        String sechma = target.getSechma();
        Connector connector = this.rsfNetManager.findConnectorBySechma(sechma);
        if (connector == null) {
            throw new RsfException(505, "protocol is not support, invalid address ->" + target.toHostSchema());
        }
        return connector;
    }

    private class Transport
    extends ReceivedAdapter
    implements SenderListener {
        private Transport() {
        }

        @Override
        public void receivedMessage(InterAddress form, ResponseInfo response) {
            AbstractRsfContext.this.rsfCaller.putResponse(response);
        }

        @Override
        public void receivedMessage(InterAddress form, RequestInfo request) {
            AbstractRsfContext.this.rsfCaller.onRequest(form, request);
        }

        @Override
        public void sendRequest(InterAddress toAddress, RequestInfo info, SendCallBack callBack) {
            try {
                Connector connector = AbstractRsfContext.this.findConnector(toAddress);
                RsfChannel channel = connector.getOrConnectionTo(toAddress).get();
                if (channel == null) {
                    throw new RsfException(600, "Invalid address ->" + toAddress.toHostSchema());
                }
                channel.sendData(info, callBack);
            }
            catch (Throwable e) {
                AbstractRsfContext.this.addressPool.invalidAddress(toAddress);
                AbstractRsfContext.this.rsfCaller.putResponse(info.getRequestID(), e);
                AbstractRsfContext.this.logger.error("sendRequest - " + e.getMessage());
            }
        }

        @Override
        public void sendResponse(InterAddress toAddress, ResponseInfo info, SendCallBack callBack) {
            try {
                Connector connector = AbstractRsfContext.this.findConnector(toAddress);
                RsfChannel channel = connector.getOrConnectionTo(toAddress).get();
                if (channel == null) {
                    throw new RsfException(600, "Invalid address ->" + toAddress.toHostSchema());
                }
                channel.sendData(info, callBack);
            }
            catch (Throwable e) {
                AbstractRsfContext.this.addressPool.invalidAddress(toAddress);
                AbstractRsfContext.this.logger.error("sendResponse - " + e.getMessage(), e);
            }
        }
    }
}

