/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.caller.remote;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfFilter;
import net.hasor.rsf.SerializeCoder;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfRuntimeUtils;
import net.hasor.rsf.domain.RsfServiceType;
import net.hasor.rsf.rpc.caller.RsfFilterHandler;
import net.hasor.rsf.rpc.caller.RsfResponseObject;
import net.hasor.rsf.rpc.caller.remote.RemoteRsfCaller;
import net.hasor.rsf.rpc.caller.remote.RsfInvokeFilterChain;
import net.hasor.rsf.rpc.caller.remote.RsfRequestFormRemote;
import net.hasor.rsf.utils.ProtocolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class InvokerProcessing
implements Runnable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RemoteRsfCaller rsfCaller;
    private final InterAddress target;
    private final RequestInfo requestInfo;
    private final ClassLoader classLoader;
    private final RsfEnvironment rsfEnv;

    public InvokerProcessing(InterAddress target, RemoteRsfCaller rsfCaller, RequestInfo requestInfo) {
        this.target = target;
        this.rsfCaller = rsfCaller;
        this.requestInfo = requestInfo;
        this.classLoader = rsfCaller.getContext().getClassLoader();
        this.rsfEnv = rsfCaller.getContainer().getEnvironment();
    }

    public InterAddress getTarget() {
        return this.target;
    }

    public RemoteRsfCaller getRsfCaller() {
        return this.rsfCaller;
    }

    @Override
    public void run() {
        ResponseInfo info;
        String errorMessage;
        int clientTimeout;
        int timeout;
        long requestID = this.requestInfo.getRequestID();
        String group = this.requestInfo.getServiceGroup();
        String name = this.requestInfo.getServiceName();
        String version = this.requestInfo.getServiceVersion();
        RsfBindInfo<?> bindInfo = this.rsfCaller.getContainer().getRsfBindInfo(group, name, version);
        if (bindInfo == null || RsfServiceType.Provider != bindInfo.getServiceType()) {
            String serviceID = "[" + group + "]" + name + "-" + version;
            String errorInfo = "do request(" + requestID + ") failed -> service " + serviceID + " not exist.";
            this.logger.error(errorInfo);
            ResponseInfo info2 = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)404, errorInfo);
            this.sendResponse(info2);
            return;
        }
        long lostTime = System.currentTimeMillis() - this.requestInfo.getReceiveTime();
        if (lostTime > (long)(timeout = this.validateTimeout(clientTimeout = this.requestInfo.getClientTimeout(), bindInfo))) {
            String errorInfo = "do request(" + requestID + ") failed -> timeout for server.";
            this.logger.error(errorInfo);
            ResponseInfo info3 = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)408, errorInfo);
            this.sendResponse(info3);
            return;
        }
        String serializeType = this.requestInfo.getSerializeType();
        Object[] pObjects = null;
        Class[] pTypes = null;
        try {
            SerializeCoder coder = this.rsfEnv.getSerializeCoder(serializeType);
            if (coder == null) {
                String errorInfo = "do request(" + requestID + ") failed -> serializeType(" + serializeType + ") is undefined.";
                this.logger.error(errorInfo);
                ResponseInfo info4 = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)210, errorInfo);
                this.sendResponse(info4);
                return;
            }
            List<String> pTypeList = this.requestInfo.getParameterTypes();
            List<Object> pObjectList = this.requestInfo.getParameterValues();
            if (pTypeList.size() != pObjectList.size()) {
                String errorInfo = "do request(" + requestID + ") failed -> parameters count and types count, not equal.";
                this.logger.error(errorInfo);
                ResponseInfo info5 = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)500, errorInfo);
                this.sendResponse(info5);
                return;
            }
            pTypes = new Class[pTypeList.size()];
            pObjects = new Object[pObjectList.size()];
            for (int i = 0; i < pTypeList.size(); ++i) {
                String paramTypeStr = pTypeList.get(i);
                Object paramObject = pObjectList.get(i);
                pTypes[i] = RsfRuntimeUtils.getType(paramTypeStr, this.classLoader);
                pObjects[i] = paramObject;
            }
        }
        catch (Throwable e) {
            String errorMessage2 = "(" + e.getClass().getName() + ")" + e.getMessage();
            String errorInfo = "do request(" + requestID + ") failed -> serializeType(" + serializeType + ") ,serialize error: " + errorMessage2;
            this.logger.error(errorInfo, e);
            ResponseInfo info6 = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)511, errorInfo);
            this.sendResponse(info6);
            return;
        }
        Method targetMethod = null;
        try {
            String methodName = this.requestInfo.getTargetMethod();
            targetMethod = bindInfo.getBindType().getMethod(methodName, pTypes);
        }
        catch (Throwable e) {
            errorMessage = "(" + e.getClass().getName() + ")" + e.getMessage();
            String errorInfo = "do request(" + requestID + ") failed -> lookup service method error : " + errorMessage;
            this.logger.error(errorInfo, e);
            info = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)403, errorInfo);
            this.sendResponse(info);
            return;
        }
        try {
            RsfRequestFormRemote rsfRequest = new RsfRequestFormRemote(this.target, this.requestInfo, bindInfo, targetMethod, pObjects, this.rsfCaller);
            RsfResponseObject rsfResponse = new RsfResponseObject(rsfRequest);
            rsfResponse.addOptionMap(this.rsfCaller.getContext().getSettings().getServerOption());
            String serviceID = bindInfo.getBindID();
            Supplier<RsfFilter>[] rsfFilters = this.rsfCaller.getContainer().getFilterProviders(serviceID);
            new RsfFilterHandler(rsfFilters, RsfInvokeFilterChain.Default).doFilter(rsfRequest, rsfResponse);
            this.sendResponse(rsfResponse);
        }
        catch (Throwable e) {
            errorMessage = "(" + e.getClass().getName() + ")" + e.getMessage();
            String msgLog = "do request(" + requestID + ") failed -> service " + bindInfo.getBindID() + ", error :" + errorMessage;
            this.logger.error(msgLog, e);
            info = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)500, msgLog);
            this.sendResponse(info);
        }
    }

    private int validateTimeout(int timeout, RsfBindInfo<?> bindInfo) {
        if (timeout <= 0) {
            timeout = this.rsfCaller.getContext().getSettings().getDefaultTimeout();
        }
        if (timeout > bindInfo.getClientTimeout()) {
            timeout = bindInfo.getClientTimeout();
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(RsfResponseObject rsfResponse) {
        if (this.requestInfo.isMessage()) {
            return;
        }
        String serializeType = this.requestInfo.getSerializeType();
        long requestID = rsfResponse.getRequestID();
        ResponseInfo info = null;
        try {
            SerializeCoder coder = this.rsfEnv.getSerializeCoder(serializeType);
            if (coder == null) {
                String errorInfo = "do request(" + requestID + ") failed -> serializeType(" + serializeType + ") is undefined.";
                this.logger.error(errorInfo);
                info = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)210, errorInfo);
            } else {
                info = ProtocolUtils.buildResponseInfo(this.rsfEnv, rsfResponse);
            }
            this.sendResponse(info);
        }
        catch (Throwable e) {
            try {
                info = null;
                String errorMessage = "(" + e.getClass().getName() + ")" + e.getMessage();
                String errorInfo = "do request(" + requestID + ") failed -> serializeType(" + serializeType + ") ,serialize error: " + errorMessage;
                this.logger.error(errorInfo, e);
                info = ProtocolUtils.buildResponseStatus(this.rsfEnv, requestID, (short)511, errorInfo);
                this.sendResponse(info);
            }
            catch (Throwable throwable) {
                this.sendResponse(info);
                throw throwable;
            }
        }
    }

    protected final void sendResponse(ResponseInfo info) {
        if (this.requestInfo.isMessage()) {
            return;
        }
        this.doSendResponse(info);
    }

    protected abstract void doSendResponse(ResponseInfo var1);
}

