/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.caller;

import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfRequest;
import net.hasor.rsf.RsfResponse;
import net.hasor.rsf.domain.OptionInfo;
import net.hasor.utils.StringUtils;

public class RsfResponseObject
extends OptionInfo
implements RsfResponse {
    private final RsfRequest rsfRequest;
    private short status = 0;
    private Object returnObject = null;
    private boolean committed = false;

    public RsfResponseObject(RsfRequest rsfRequest) {
        this.rsfRequest = rsfRequest;
    }

    public String toString() {
        return "responseID:" + this.getRequestID() + " from Setvice " + this.getBindInfo();
    }

    @Override
    public RsfBindInfo<?> getBindInfo() {
        return this.rsfRequest.getBindInfo();
    }

    @Override
    public long getRequestID() {
        return this.rsfRequest.getRequestID();
    }

    @Override
    public String getSerializeType() {
        return this.rsfRequest.getSerializeType();
    }

    @Override
    public Object getData() {
        return this.returnObject;
    }

    @Override
    public Class<?> getReturnType() {
        return this.rsfRequest.getMethod().getReturnType();
    }

    @Override
    public short getStatus() {
        return this.status;
    }

    @Override
    public void sendData(Object returnObject) {
        this.updateReturn((short)200, returnObject, null);
    }

    @Override
    public void sendStatus(short status) {
        this.updateReturn(status, null, null);
    }

    @Override
    public void sendStatus(short status, String returnMessage) {
        this.updateReturn(status, null, returnMessage);
    }

    private void updateReturn(short status, Object returnData, String returnMessage) {
        this.status = status;
        this.returnObject = returnData;
        this.committed = true;
        if (StringUtils.isNotBlank((String)returnMessage)) {
            this.addOption("message", returnMessage);
        }
    }

    @Override
    public boolean isResponse() {
        return this.committed;
    }
}

