/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.caller;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfFuture;
import net.hasor.rsf.RsfResponse;
import net.hasor.rsf.container.RsfBeanContainer;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.domain.RsfFlags;
import net.hasor.rsf.domain.RsfRuntimeUtils;
import net.hasor.rsf.domain.provider.AddressProvider;
import net.hasor.rsf.rpc.caller.RsfRequestFormLocal;
import net.hasor.rsf.rpc.caller.RsfRequestManager;
import net.hasor.rsf.rpc.caller.RsfServiceWrapper;
import net.hasor.rsf.rpc.caller.SenderListener;
import net.hasor.utils.future.FutureCallback;

public class RsfCaller
extends RsfRequestManager {
    private RsfBeanContainer rsfBeanContainer = null;
    private final Object LOCK_OBJECT = new Object();
    private final ConcurrentMap<String, Class<RsfServiceWrapper>> wrapperMap = new ConcurrentHashMap<String, Class<RsfServiceWrapper>>();

    public RsfCaller(RsfContext rsfContext, RsfBeanContainer rsfBeanContainer, SenderListener senderListener) {
        super(rsfContext, senderListener);
        this.rsfBeanContainer = rsfBeanContainer;
    }

    @Override
    public RsfBeanContainer getContainer() {
        return this.rsfBeanContainer;
    }

    public Object getRemoteByID(AddressProvider target, String serviceID) throws RsfException {
        RsfBindInfo<?> bindInfo = this.getContainer().getRsfBindInfo(serviceID);
        if (bindInfo == null) {
            logger.error("service {} is undefined.", (Object)serviceID);
            throw new IllegalStateException("service " + serviceID + " is undefined.");
        }
        return this.wrapper(target, bindInfo, bindInfo.getBindType());
    }

    public Object getRemote(AddressProvider target, String group, String name, String version) throws RsfException {
        RsfBindInfo<?> bindInfo = this.getContainer().getRsfBindInfo(group, name, version);
        if (bindInfo == null) {
            logger.error("the group={} ,name={} ,version={} is undefined.", new Object[]{group, name, version});
            throw new IllegalStateException("the group=" + group + " ,name=" + name + " ,version=" + version + " is undefined.");
        }
        return this.getRemote(target, bindInfo);
    }

    public <T> T getRemote(AddressProvider target, RsfBindInfo<T> bindInfo) throws RsfException {
        if (bindInfo == null) {
            throw new NullPointerException("the bindInfo is null.");
        }
        return this.wrapper(target, bindInfo, bindInfo.getBindType());
    }

    public <T> T wrapperByID(AddressProvider target, String serviceID, Class<T> interFace) throws RsfException {
        RsfBindInfo<?> bindInfo = this.getContainer().getRsfBindInfo(serviceID);
        if (bindInfo == null) {
            logger.error("service {} is undefined.", (Object)serviceID);
            throw new IllegalStateException("service " + serviceID + " is undefined.");
        }
        return this.wrapper(target, bindInfo, interFace);
    }

    public <T> T wrapper(AddressProvider target, Class<T> interFace) throws RsfException {
        if (interFace == null) {
            throw new NullPointerException("the interFace is null.");
        }
        RsfBindInfo<T> bindInfo = this.getContainer().getRsfBindInfo(interFace);
        if (bindInfo == null) {
            logger.error("service {} is undefined.", (Object)interFace.getName());
            throw new IllegalStateException("service " + interFace.getName() + " is undefined.");
        }
        return this.wrapper(target, bindInfo, interFace);
    }

    public <T> T wrapper(AddressProvider target, String group, String name, String version, Class<T> interFace) throws RsfException {
        RsfBindInfo<?> bindInfo = this.getContainer().getRsfBindInfo(group, name, version);
        if (bindInfo == null) {
            return null;
        }
        return this.wrapper(target, bindInfo, interFace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T wrapper(AddressProvider target, RsfBindInfo<?> bindInfo, Class<T> interFace) throws RsfException {
        if (bindInfo == null) {
            throw new NullPointerException();
        }
        if (!interFace.isInterface()) {
            logger.error("interFace {} parameter must be an interFace.", (Object)interFace.getName());
            throw new UnsupportedOperationException("interFace " + interFace.getName() + " parameter must be an interFace.");
        }
        String bindID = bindInfo.getBindID();
        Class<?> wrapperClass = (Class<?>)this.wrapperMap.get(bindID);
        if (wrapperClass == null) {
            Object object = this.LOCK_OBJECT;
            synchronized (object) {
                wrapperClass = (Class)this.wrapperMap.get(bindID);
                if (wrapperClass == null) {
                    try {
                        ClassLoader loader = this.getContext().getClassLoader();
                        wrapperClass = Proxy.getProxyClass(loader, RsfServiceWrapper.class, interFace);
                        this.wrapperMap.put(bindID, wrapperClass);
                    }
                    catch (Throwable e) {
                        throw new RsfException(e.getMessage(), e);
                    }
                }
            }
        }
        try {
            Constructor constructor = wrapperClass.getConstructor(InvocationHandler.class);
            RsfServiceWrapper wrapper = (RsfServiceWrapper)constructor.newInstance(new ServiceMethodDelegateByProxy(bindInfo));
            wrapper.setTarget(target);
            return (T)wrapper;
        }
        catch (Throwable e) {
            logger.error("new wrapperClass failed -> service={}, interFace {}, error={}", new Object[]{bindID, interFace.getName(), e.getMessage(), e});
            throw new RsfException(e.getMessage(), e);
        }
    }

    public Object syncInvoke(AddressProvider target, RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects) throws InterruptedException, ExecutionException, TimeoutException {
        int timeout = this.validateTimeout(bindInfo.getClientTimeout());
        RsfRequestFormLocal request = this.buildRsfRequestFormLocal(target, bindInfo, methodName, parameterTypes, parameterObjects);
        RsfFuture rsfFuture = this.doSendRequest(request, null);
        return ((RsfResponse)rsfFuture.get(timeout, TimeUnit.MILLISECONDS)).getData();
    }

    public RsfFuture asyncInvoke(AddressProvider target, RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects) {
        RsfRequestFormLocal request = this.buildRsfRequestFormLocal(target, bindInfo, methodName, parameterTypes, parameterObjects);
        return this.doSendRequest(request, null);
    }

    public void callBackInvoke(AddressProvider target, RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects, final FutureCallback<Object> listener) {
        this.callBackRequest(target, bindInfo, methodName, parameterTypes, parameterObjects, new FutureCallback<RsfResponse>(){

            public void completed(RsfResponse result) {
                listener.completed(result.getData());
            }

            public void failed(Throwable ex) {
                listener.failed(ex);
            }
        });
    }

    public void callBackRequest(AddressProvider target, RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects, FutureCallback<RsfResponse> listener) {
        RsfRequestFormLocal request = this.buildRsfRequestFormLocal(target, bindInfo, methodName, parameterTypes, parameterObjects);
        this.doSendRequest(request, listener);
    }

    private int validateTimeout(int timeout) {
        if (timeout <= 0) {
            timeout = this.getContext().getSettings().getDefaultTimeout();
        }
        return timeout;
    }

    private RsfRequestFormLocal buildRsfRequestFormLocal(AddressProvider target, RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects) {
        short flags = 0;
        if (target.isDistributed()) {
            flags = RsfFlags.P2PFlag.addTag(flags);
        }
        Method targetMethod = RsfRuntimeUtils.getServiceMethod(bindInfo.getBindType(), methodName, parameterTypes);
        InterAddress targetAddress = target.get(bindInfo.getBindID(), methodName, parameterObjects);
        return new RsfRequestFormLocal(targetAddress, flags, bindInfo, targetMethod, parameterObjects, this);
    }

    private class ServiceMethodDelegateByProxy
    implements InvocationHandler {
        private RsfBindInfo<?> bindInfo;
        private AddressProvider target;

        public ServiceMethodDelegateByProxy(RsfBindInfo<?> bindInfo) {
            this.bindInfo = bindInfo;
        }

        @Override
        public Object invoke(Object target, Method callMethod, Object[] params) throws Throwable {
            if ("getTarget".equals(callMethod.getName())) {
                return this.target;
            }
            if ("setTarget".equals(callMethod.getName())) {
                this.target = (AddressProvider)params[0];
                return null;
            }
            if ("toString".equals(callMethod.getName())) {
                return this.target.toString();
            }
            RsfServiceWrapper wrapper = (RsfServiceWrapper)target;
            AddressProvider targetAddress = wrapper.getTarget();
            return RsfCaller.this.syncInvoke(targetAddress, this.bindInfo, callMethod.getName(), callMethod.getParameterTypes(), params);
        }
    }
}

