/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.rsf.v1;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.hasor.rsf.protocol.rsf.Protocol;
import net.hasor.rsf.protocol.rsf.v1.ResponseBlock;
import net.hasor.rsf.utils.ProtocolUtils;

public class RpcResponseProtocolV1
implements Protocol<ResponseBlock> {
    @Override
    public void encode(ResponseBlock resMsg, ByteBuf buf) throws IOException {
        buf.writeByte((int)resMsg.getHead());
        buf.writeLong(resMsg.getRequestID());
        buf.writeByte(0);
        ByteBuf responseBody = this.encodeResponse(resMsg);
        int bodyLength = responseBody.readableBytes();
        bodyLength = bodyLength << 8 >>> 8;
        buf.writeMedium(bodyLength);
        buf.writeBytes(responseBody);
    }

    private ByteBuf encodeResponse(ResponseBlock resMsg) {
        ByteBuf bodyBuf = ProtocolUtils.newByteBuf();
        bodyBuf.writeShort((int)resMsg.getStatus());
        bodyBuf.writeShort((int)resMsg.getSerializeType());
        bodyBuf.writeShort((int)resMsg.getReturnType());
        bodyBuf.writeShort((int)resMsg.getReturnData());
        int[] optionMapping = resMsg.getOptions();
        bodyBuf.writeByte(optionMapping.length);
        for (int i = 0; i < optionMapping.length; ++i) {
            bodyBuf.writeInt(optionMapping[i]);
        }
        resMsg.fillTo(bodyBuf);
        return bodyBuf;
    }

    @Override
    public ResponseBlock decode(ByteBuf buf) throws IOException {
        byte version = buf.readByte();
        long requestID = buf.readLong();
        buf.skipBytes(1);
        buf.skipBytes(3);
        ResponseBlock res = new ResponseBlock();
        res.setHead(version);
        res.setRequestID(requestID);
        res.setStatus(buf.readShort());
        res.setSerializeType(buf.readShort());
        res.setReturnType(buf.readShort());
        res.setReturnData(buf.readShort());
        int optionCount = buf.readByte();
        for (int i = 0; i < optionCount; ++i) {
            int mergeData = buf.readInt();
            res.addOption(mergeData);
        }
        res.fillFrom(buf);
        return res;
    }
}

