/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.rsf.v1;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.hasor.rsf.protocol.rsf.Protocol;
import net.hasor.rsf.protocol.rsf.v1.RequestBlock;
import net.hasor.rsf.utils.ProtocolUtils;

public class RpcRequestProtocolV1
implements Protocol<RequestBlock> {
    @Override
    public void encode(RequestBlock reqMsg, ByteBuf buf) throws IOException {
        buf.writeByte((int)reqMsg.getHead());
        buf.writeLong(reqMsg.getRequestID());
        buf.writeByte(0);
        ByteBuf requestBody = this.encodeRequest(reqMsg);
        int bodyLength = requestBody.readableBytes();
        bodyLength = bodyLength << 8 >>> 8;
        buf.writeMedium(bodyLength);
        buf.writeBytes(requestBody);
    }

    private ByteBuf encodeRequest(RequestBlock reqMsg) {
        ByteBuf bodyBuf = ProtocolUtils.newByteBuf();
        bodyBuf.writeShort((int)reqMsg.getServiceName());
        bodyBuf.writeShort((int)reqMsg.getServiceGroup());
        bodyBuf.writeShort((int)reqMsg.getServiceVersion());
        bodyBuf.writeShort((int)reqMsg.getTargetMethod());
        bodyBuf.writeShort((int)reqMsg.getSerializeType());
        bodyBuf.writeInt(reqMsg.getClientTimeout());
        bodyBuf.writeShort((int)reqMsg.getFlags());
        int[] paramMapping = reqMsg.getParameters();
        bodyBuf.writeByte(paramMapping.length);
        for (int i = 0; i < paramMapping.length; ++i) {
            bodyBuf.writeInt(paramMapping[i]);
        }
        int[] optionMapping = reqMsg.getOptions();
        bodyBuf.writeByte(optionMapping.length);
        for (int i = 0; i < optionMapping.length; ++i) {
            bodyBuf.writeInt(optionMapping[i]);
        }
        reqMsg.fillTo(bodyBuf);
        return bodyBuf;
    }

    @Override
    public RequestBlock decode(ByteBuf buf) throws IOException {
        byte rsfHead = buf.readByte();
        long requestID = buf.readLong();
        buf.skipBytes(1);
        buf.skipBytes(3);
        RequestBlock req = new RequestBlock();
        req.setHead(rsfHead);
        req.setRequestID(requestID);
        req.setServiceName(buf.readShort());
        req.setServiceGroup(buf.readShort());
        req.setServiceVersion(buf.readShort());
        req.setTargetMethod(buf.readShort());
        req.setSerializeType(buf.readShort());
        req.setClientTimeout(buf.readInt());
        req.setFlags(buf.readShort());
        int paramCount = buf.readByte();
        for (int i = 0; i < paramCount; ++i) {
            int mergeData = buf.readInt();
            req.addParameter(mergeData);
        }
        int optionCount = buf.readByte();
        for (int i = 0; i < optionCount; ++i) {
            int mergeData = buf.readInt();
            req.addOption(mergeData);
        }
        req.fillFrom(buf);
        return req;
    }
}

