/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.rsf.v1;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import net.hasor.rsf.protocol.rsf.v1.ArrayUtils;
import net.hasor.rsf.utils.IOUtils;
import net.hasor.rsf.utils.ProtocolUtils;

public class PoolBlock {
    public static final int NULL_MARK = -1;
    public static int DataMaxSize = 0xFFFFFF;
    public static short PoolMaxSize = (short)4095;
    private int[] poolMap = new int[0];
    private ByteBuf poolData = ProtocolUtils.newByteBuf();

    public void fillFrom(ByteBuf formData) {
        if (formData == null) {
            return;
        }
        int attrPoolSize = PoolMaxSize & formData.readShort();
        for (int i = 0; i < attrPoolSize; ++i) {
            int length = formData.readInt();
            this.poolMap = ArrayUtils.add(this.poolMap, length);
        }
        this.poolData.writeBytes(formData);
    }

    public void fillTo(ByteBuf toData) {
        if (toData == null) {
            return;
        }
        toData.writeShort(this.poolMap.length);
        for (int i = 0; i < this.poolMap.length; ++i) {
            toData.writeInt(this.poolMap[i]);
        }
        toData.writeBytes(this.poolData);
    }

    public short pushData(byte[] dataArray) {
        if (this.poolMap.length >= PoolMaxSize) {
            throw new IndexOutOfBoundsException("poolMax size is " + PoolMaxSize);
        }
        int datalength = dataArray == null ? -1 : dataArray.length;
        this.poolMap = ArrayUtils.add(this.poolMap, datalength);
        if (datalength > 0) {
            this.poolData.writeBytes(dataArray);
        }
        return (short)(this.poolMap.length - 1);
    }

    public int getPoolLength() {
        return this.poolMap.length;
    }

    public int getPoolSize() {
        int rawSize = 0;
        for (int i = 0; i < this.poolMap.length; ++i) {
            int atPoolData = this.poolMap[i];
            if (atPoolData <= 0) continue;
            rawSize += this.poolMap[i];
        }
        return rawSize;
    }

    public int[] getPoolData() {
        return this.poolMap;
    }

    public byte[] readPool(short attrIndex) {
        if (this.poolMap[attrIndex] == -1) {
            return null;
        }
        int rawIndex = 0;
        for (int i = 0; i < this.poolMap.length && i != attrIndex; ++i) {
            if (this.poolMap[i] == -1) continue;
            rawIndex += this.poolMap[i];
        }
        int readLength = this.poolMap[attrIndex];
        if (readLength == -1) {
            return null;
        }
        byte[] data = new byte[readLength];
        this.poolData.getBytes(rawIndex, data, 0, readLength);
        return data;
    }

    public void release() {
        IOUtils.releaseByteBuf((ReferenceCounted)this.poolData);
        this.poolMap = null;
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }
}

