/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.http_hprose;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.domain.RsfServiceType;
import net.hasor.rsf.hprose.io.HproseReader;
import net.hasor.rsf.hprose.io.HproseWriter;
import net.hasor.rsf.protocol.http_hprose.HproseConstants;
import net.hasor.rsf.utils.ProtocolUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.json.JSON;

public class HproseUtils
implements HproseConstants {
    public static String[] doFunction(RsfContext rsfContext) throws IOException {
        LinkedHashSet<String> allMethod = new LinkedHashSet<String>();
        allMethod.add("*");
        List<String> serviceIDs = rsfContext.getServiceIDs();
        for (String serviceID : serviceIDs) {
            Method[] methodArrays;
            String aliasName;
            RsfBindInfo serviceInfo = rsfContext.getServiceInfo(serviceID);
            if (serviceInfo.isShadow() || RsfServiceType.Provider != serviceInfo.getServiceType() || StringUtils.isBlank((String)(aliasName = serviceInfo.getAliasName("Hprose")))) continue;
            for (Method method : methodArrays = serviceInfo.getBindType().getMethods()) {
                StringBuilder define = new StringBuilder();
                define = define.append(aliasName);
                define = define.append("_");
                define = define.append(method.getName());
                allMethod.add(define.toString());
            }
        }
        return allMethod.toArray(new String[allMethod.size()]);
    }

    public static RequestInfo[] doCall(RsfContext rsfContext, InputStream content, String requestURI, String origin) throws RsfException, IOException {
        HproseReader reader = new HproseReader(content);
        ArrayList<RequestInfo> infoArrays = new ArrayList<RequestInfo>();
        HproseUtils.parseRequest(rsfContext, reader, infoArrays);
        content.skip(content.available());
        for (RequestInfo info : infoArrays) {
            info.addOption("Location", requestURI);
            info.addOption("Origin", origin);
        }
        return infoArrays.toArray(new RequestInfo[infoArrays.size()]);
    }

    private static void parseRequest(RsfContext rsfContext, HproseReader reader, List<RequestInfo> infoArrays) throws IOException {
        long requestID = 12345L;
        String callName = null;
        try {
            callName = reader.readString();
            reader.reset();
        }
        catch (IOException e) {
            throw new RsfException(506, "decode callName error -> " + e.getMessage());
        }
        RsfBindInfo serviceInfo = null;
        RequestInfo request = new RequestInfo();
        request.setRequestID(requestID);
        try {
            String[] lastParams = callName.split("_");
            String methodName = lastParams[lastParams.length - 1];
            String serviceID = callName.substring(0, callName.length() - methodName.length() - 1);
            serviceInfo = rsfContext.getServiceInfo("Hprose", serviceID);
            if (serviceInfo == null) {
                throw new RsfException(404, "serviceID not found in alias. -> " + serviceID);
            }
            request.setServiceGroup(serviceInfo.getBindGroup());
            request.setServiceName(serviceInfo.getBindName());
            request.setServiceVersion(serviceInfo.getBindVersion());
            request.setTargetMethod(methodName);
            request.setMessage(false);
            request.setSerializeType("Hprose");
            request.setClientTimeout(rsfContext.getSettings().getDefaultTimeout());
            request.setReceiveTime(System.currentTimeMillis());
        }
        catch (Exception e) {
            if (e instanceof RsfException) {
                throw (RsfException)e;
            }
            throw new RsfException(0, "error(" + e.getClass() + ") -> " + e.getMessage());
        }
        int lastTag = 0;
        Method atMethod = null;
        Class<?>[] parameterTypes = null;
        Object args = null;
        try {
            int argCount = 0;
            String methodName = request.getTargetMethod();
            lastTag = reader.checkTags(String.valueOf('a') + 'z' + 'C');
            if (lastTag == 97) {
                reader.reset();
                argCount = reader.readInt(123);
                args = new byte[argCount][];
                for (int i = 0; i < argCount; ++i) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    reader.readRaw(out);
                    args[i] = out.toByteArray();
                }
                reader.readInt(125);
            }
            args = args == null ? (Object)new byte[0][] : args;
            Method[] allMethods = serviceInfo.getBindType().getMethods();
            for (Method method : allMethods) {
                if (!method.getName().equals(methodName) || argCount != (parameterTypes = method.getParameterTypes()).length) continue;
                atMethod = method;
                break;
            }
            if (atMethod == null) {
                throw new RsfException(404, "serviceID : " + serviceInfo.getBindID() + " ,not found method " + methodName);
            }
        }
        catch (Exception e) {
            if (e instanceof RsfException) {
                throw (RsfException)e;
            }
            throw new RsfException(0, "error(" + e.getClass() + ") -> " + e.getMessage());
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramType = parameterTypes[i];
            HproseReader paramDataReader = new HproseReader(args[i]);
            Object paramData = paramDataReader.unserialize(paramType);
            request.addParameter(paramType.getName(), paramData);
        }
        infoArrays.add(request);
        try {
            if (lastTag == 122) {
                return;
            }
            lastTag = reader.checkTags(String.valueOf('t') + 'z' + 'C');
        }
        catch (Exception e) {
            if (e instanceof RsfException) {
                throw (RsfException)e;
            }
            throw new RsfException(511, "error(" + e.getClass() + ") reader.checkTags -> " + e.getMessage());
        }
        if (lastTag == 122) {
            return;
        }
        if (lastTag == 67) {
            throw new RsfException(506, "net.hasor.rsf.hprose batch calls, is not support.");
        }
        if (lastTag == 116) {
            throw new RsfException(506, "net.hasor.rsf.hprose ref param, is not support.");
        }
    }

    public static void parseResponse(long requestID, ResponseInfo response, OutputStream output) throws IOException {
        if (response.getStatus() == 200) {
            output.write(new byte[]{82});
            ByteArrayOutputStream binary = new ByteArrayOutputStream();
            HproseWriter writer = new HproseWriter(binary);
            writer.serialize(response.getReturnData());
            byte[] encode = binary.toByteArray();
            output.write(encode);
            output.write(new byte[]{122});
        } else {
            HashMap<String, String> errorMsg = new HashMap<String, String>();
            String[] optionKeys = response.getOptionKeys();
            if (optionKeys != null) {
                for (String optKey : optionKeys) {
                    errorMsg.put(optKey, response.getOption(optKey));
                }
            }
            errorMsg.put("requestID", String.valueOf(requestID));
            errorMsg.put("status", String.valueOf(response.getStatus()));
            String jsonData = JSON.toString(errorMsg);
            String data = "s" + jsonData.length() + "\"" + jsonData + "\"z";
            output.write(new byte[]{69});
            output.write(data.getBytes());
        }
    }

    public static ByteBuf encodeRequest(RsfContext rsfContext, RequestInfo request) throws IOException {
        RsfBindInfo bindInfo = rsfContext.getServiceInfo(request.getServiceGroup(), request.getServiceName(), request.getServiceVersion());
        String aliasName = bindInfo.getAliasName("Hprose");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HproseWriter writer = new HproseWriter(out);
        writer.writeString(aliasName + "_" + request.getTargetMethod());
        writer.writeArray(request.getParameterValues().toArray());
        ByteBuf outBuf = ProtocolUtils.newByteBuf();
        outBuf.writeByte(67);
        outBuf.writeBytes(out.toByteArray());
        outBuf.writeByte(122);
        return outBuf;
    }

    public static Object decodeResponse(InputStream inputStream) throws IOException {
        int aByte = inputStream.read();
        if ((char)aByte == 'R') {
            HproseReader reader = new HproseReader(inputStream);
            return reader.unserialize();
        }
        return null;
    }
}

