/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.hasor.rsf.hprose.util.concurrent.Action;
import net.hasor.rsf.hprose.util.concurrent.Promise;
import net.hasor.rsf.hprose.util.concurrent.State;

public class PromiseFuture<V>
implements Future<V> {
    private final Semaphore sem = new Semaphore(0);
    private final Promise<V> promise;
    private volatile V result;
    private volatile boolean canneled = false;

    public PromiseFuture(Promise<V> promise) {
        this.promise = promise;
        promise.then(new Action<V>(){

            @Override
            public void call(V value) throws Throwable {
                PromiseFuture.this.result = value;
                PromiseFuture.this.sem.release();
            }
        }, new Action<Throwable>(){

            @Override
            public void call(Throwable value) throws Throwable {
                PromiseFuture.this.sem.release();
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.isDone()) {
            this.canneled = true;
            this.sem.release();
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.canneled;
    }

    @Override
    public boolean isDone() {
        return this.canneled || this.promise.getState() != State.PENDING;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (!this.canneled) {
            this.sem.acquire();
            switch (this.promise.getState()) {
                case FULFILLED: {
                    return this.result;
                }
                case REJECTED: {
                    throw new ExecutionException(this.promise.getReason());
                }
            }
        }
        throw new InterruptedException();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.canneled) {
            if (this.sem.tryAcquire(timeout, unit)) {
                switch (this.promise.getState()) {
                    case FULFILLED: {
                        return this.result;
                    }
                    case REJECTED: {
                        throw new ExecutionException(this.promise.getReason());
                    }
                }
            } else {
                throw new TimeoutException();
            }
        }
        throw new InterruptedException();
    }
}

