/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import net.hasor.rsf.hprose.io.HproseClassManager;

public final class ClassUtil {
    public static final String getClassAlias(Class<?> type) {
        String className = HproseClassManager.getClassAlias(type);
        if (className == null) {
            className = type.getName().replace('.', '_').replace('$', '_');
            HproseClassManager.register(type, className);
        }
        return className;
    }

    private static Class<?> toClass(Type[] bounds) {
        Type boundType;
        if (bounds.length == 1 && (boundType = bounds[0]) instanceof Class) {
            return (Class)boundType;
        }
        return Object.class;
    }

    public static final Class<?> toClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof WildcardType) {
            return ClassUtil.toClass(((WildcardType)type).getUpperBounds());
        }
        if (type instanceof TypeVariable) {
            return ClassUtil.toClass(((TypeVariable)type).getBounds());
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.toClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ClassUtil.toClass(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return Object.class;
    }

    public static final Type getComponentType(Type type) {
        return type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : (type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : (((Class)type).isArray() ? ((Class)type).getComponentType() : Object.class));
    }

    public static final Type getKeyType(Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
    }

    public static final Type getValueType(Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[1] : Object.class;
    }

    public static final Type getActualType(Type type, Type paramType) {
        if (type instanceof ParameterizedType && paramType instanceof TypeVariable) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<?>[] typeParameters = ((TypeVariable)paramType).getGenericDeclaration().getTypeParameters();
            int n = typeParameters.length;
            for (int i = 0; i < n; ++i) {
                if (!typeParameters[i].equals(paramType)) continue;
                return actualTypeArguments[i];
            }
        }
        return paramType;
    }
}

