/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.server;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import net.hasor.rsf.hprose.common.HproseContext;
import net.hasor.rsf.hprose.common.HproseMethods;
import net.hasor.rsf.hprose.io.ByteBufferStream;
import net.hasor.rsf.hprose.net.Acceptor;
import net.hasor.rsf.hprose.net.Connection;
import net.hasor.rsf.hprose.net.ConnectionHandler;
import net.hasor.rsf.hprose.net.TimeoutType;
import net.hasor.rsf.hprose.server.HproseService;
import net.hasor.rsf.hprose.server.HproseTcpMethods;
import net.hasor.rsf.hprose.server.HproseTcpServiceEvent;
import net.hasor.rsf.hprose.server.ServiceContext;
import net.hasor.rsf.hprose.server.TcpContext;
import net.hasor.rsf.hprose.util.concurrent.Action;

public class HproseTcpServer
extends HproseService {
    private static final ThreadLocal<TcpContext> currentContext = new ThreadLocal();
    private volatile ExecutorService threadPool = null;
    private volatile int readTimeout = 30000;
    private volatile int writeTimeout = 30000;
    private boolean threadPoolEnabled = false;
    private int reactorThreads = 2;
    private Acceptor acceptor = null;
    private String host = null;
    private int port = 0;

    public HproseTcpServer(String uri) throws URISyntaxException {
        URI u = new URI(uri);
        this.host = u.getHost();
        this.port = u.getPort();
    }

    public HproseTcpServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String value) {
        this.host = value;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public int getReactorThreads() {
        return this.reactorThreads;
    }

    public void setReactorThreads(int reactorThreads) {
        this.reactorThreads = reactorThreads;
    }

    public boolean isStarted() {
        return this.acceptor != null;
    }

    public void start() throws IOException {
        if (!this.isStarted()) {
            this.acceptor = new Acceptor(this.host, this.port, new ServerConnectionHandler(), this.reactorThreads);
            this.acceptor.start();
        }
    }

    public void stop() {
        if (this.isStarted()) {
            this.acceptor.close();
            if (this.threadPool != null && !this.threadPool.isShutdown()) {
                try {
                    this.threadPool.shutdown();
                }
                catch (SecurityException e) {
                    this.fireErrorEvent(e, null);
                }
            }
            this.acceptor = null;
        }
    }

    @Override
    public HproseMethods getGlobalMethods() {
        if (this.globalMethods == null) {
            this.globalMethods = new HproseTcpMethods();
        }
        return this.globalMethods;
    }

    @Override
    public void setGlobalMethods(HproseMethods methods) {
        if (!(methods instanceof HproseTcpMethods)) {
            throw new ClassCastException("methods must be a HproseTcpMethods instance");
        }
        this.globalMethods = methods;
    }

    @Override
    protected Object[] fixArguments(Type[] argumentTypes, Object[] arguments, ServiceContext context) {
        int count = arguments.length;
        TcpContext tcpContext = (TcpContext)context;
        if (argumentTypes.length != count) {
            Object[] args = new Object[argumentTypes.length];
            System.arraycopy(arguments, 0, args, 0, count);
            Class argType = (Class)argumentTypes[count];
            if (argType.equals(HproseContext.class) || argType.equals(ServiceContext.class)) {
                args[count] = context;
            } else if (argType.equals(TcpContext.class)) {
                args[count] = tcpContext;
            } else if (argType.equals(SocketChannel.class)) {
                args[count] = tcpContext.getSocketChannel();
            } else if (argType.equals(Socket.class)) {
                args[count] = tcpContext.getSocket();
            }
            return args;
        }
        return arguments;
    }

    public static TcpContext getCurrentContext() {
        return currentContext.get();
    }

    public boolean isThreadPoolEnabled() {
        return this.threadPoolEnabled;
    }

    public void setThreadPoolEnabled(boolean value) {
        if (value && this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool();
        }
        this.threadPoolEnabled = value;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService value) {
        this.threadPool = value;
        this.threadPoolEnabled = value != null;
    }

    protected void fireAcceptEvent(SocketChannel channel) {
        if (this.event != null && HproseTcpServiceEvent.class.isInstance(this.event)) {
            ((HproseTcpServiceEvent)this.event).onAccept(new TcpContext(this, channel));
        }
    }

    protected void fireCloseEvent(SocketChannel channel) {
        if (this.event != null && HproseTcpServiceEvent.class.isInstance(this.event)) {
            ((HproseTcpServiceEvent)this.event).onClose(new TcpContext(this, channel));
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    private final class ServerConnectionHandler
    implements ConnectionHandler {
        private ServerConnectionHandler() {
        }

        @Override
        public void onConnect(Connection conn) {
        }

        @Override
        public void onConnected(Connection conn) {
            HproseTcpServer.this.fireAcceptEvent(conn.socketChannel());
        }

        @Override
        public final void onReceived(Connection conn, ByteBuffer data, Integer id) {
            ServerHandler handler = new ServerHandler(conn, data, id);
            if (HproseTcpServer.this.threadPool != null) {
                try {
                    HproseTcpServer.this.threadPool.execute(handler);
                }
                catch (RejectedExecutionException e) {
                    conn.close();
                }
            } else {
                handler.run();
            }
        }

        @Override
        public final void onSended(Connection conn, ByteBuffer data, Integer id) {
            ByteBufferStream.free(data);
        }

        @Override
        public final void onClose(Connection conn) {
            HproseTcpServer.this.fireCloseEvent(conn.socketChannel());
        }

        @Override
        public void onError(Connection conn, Exception e) {
            if (conn == null) {
                HproseTcpServer.this.fireErrorEvent(e, null);
            }
        }

        @Override
        public void onTimeout(Connection conn, TimeoutType type) {
        }

        @Override
        public int getReadTimeout() {
            return HproseTcpServer.this.readTimeout;
        }

        @Override
        public int getWriteTimeout() {
            return HproseTcpServer.this.writeTimeout;
        }

        @Override
        public int getConnectTimeout() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ServerHandler
    implements Runnable {
        private final Connection conn;
        private final ByteBuffer data;
        private final Integer id;

        public ServerHandler(Connection conn, ByteBuffer data, Integer id) {
            this.conn = conn;
            this.data = data;
            this.id = id;
        }

        @Override
        public final void run() {
            TcpContext context = new TcpContext(HproseTcpServer.this, this.conn.socketChannel());
            currentContext.set(context);
            HproseTcpServer.this.handle(this.data, context).then(new Action<ByteBuffer>(){

                @Override
                public void call(ByteBuffer value) throws Throwable {
                    ServerHandler.this.conn.send(value, ServerHandler.this.id);
                }
            }).catchError(new Action<Throwable>(){

                @Override
                public void call(Throwable e) throws Throwable {
                    ServerHandler.this.conn.close();
                }
            }).whenComplete(new Runnable(){

                @Override
                public void run() {
                    currentContext.remove();
                    ByteBufferStream.free(ServerHandler.this.data);
                }
            });
        }
    }
}

