/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize.java8;

import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Duration;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public final class DurationUnserializer
extends BaseUnserializer<Duration> {
    public static final DurationUnserializer instance = new DurationUnserializer();

    @Override
    public Duration unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 101: {
                return null;
            }
            case 115: {
                return Duration.parse(ReferenceReader.readString(reader));
            }
            case 105: 
            case 108: {
                return Duration.ofNanos(ValueReader.readLong(reader));
            }
            case 100: {
                return Duration.ofNanos((long)ValueReader.readDouble(reader));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return Duration.ofNanos(tag - 48);
        }
        return (Duration)super.unserialize(reader, tag, type);
    }

    public Duration read(Reader reader) throws IOException {
        return (Duration)this.read(reader, (Type)((Object)Duration.class));
    }
}

