/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.UUID;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.util.DateTime;

public final class ValueReader {
    public static final IOException badEncoding(int c) {
        return new IOException("bad utf-8 encoding at " + (c < 0 ? "end of stream" : "0x" + Integer.toHexString(c & 0xFF)));
    }

    public static final ClassCastException castError(String srctype, Type desttype) {
        return new ClassCastException(srctype + " can't change to " + desttype.toString());
    }

    public static final ClassCastException castError(Object obj, Type type) {
        return new ClassCastException(obj.getClass().toString() + " can't change to " + type.toString());
    }

    public static final int readInt(Reader reader, int tag) throws IOException {
        InputStream stream = reader.stream;
        int result = 0;
        int i = stream.read();
        if (i == tag) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = stream.read();
            }
        }
        if (neg) {
            while (i != tag && i != -1) {
                result = result * 10 - (i - 48);
                i = stream.read();
            }
        } else {
            while (i != tag && i != -1) {
                result = result * 10 + (i - 48);
                i = stream.read();
            }
        }
        return result;
    }

    public static final long readLong(Reader reader, int tag) throws IOException {
        InputStream stream = reader.stream;
        long result = 0L;
        int i = stream.read();
        if (i == tag) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = stream.read();
            }
        }
        if (neg) {
            while (i != tag && i != -1) {
                result = result * 10L - (long)(i - 48);
                i = stream.read();
            }
        } else {
            while (i != tag && i != -1) {
                result = result * 10L + (long)(i - 48);
                i = stream.read();
            }
        }
        return result;
    }

    public static final float readLongAsFloat(Reader reader) throws IOException {
        InputStream stream = reader.stream;
        float result = 0.0f;
        int i = stream.read();
        if (i == 59) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = stream.read();
            }
        }
        if (neg) {
            while (i != 59 && i != -1) {
                result = result * 10.0f - (float)(i - 48);
                i = stream.read();
            }
        } else {
            while (i != 59 && i != -1) {
                result = result * 10.0f + (float)(i - 48);
                i = stream.read();
            }
        }
        return result;
    }

    public static final double readLongAsDouble(Reader reader) throws IOException {
        InputStream stream = reader.stream;
        double result = 0.0;
        int i = stream.read();
        if (i == 59) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = stream.read();
            }
        }
        if (neg) {
            while (i != 59 && i != -1) {
                result = result * 10.0 - (double)(i - 48);
                i = stream.read();
            }
        } else {
            while (i != 59 && i != -1) {
                result = result * 10.0 + (double)(i - 48);
                i = stream.read();
            }
        }
        return result;
    }

    public static final float parseFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return Float.NaN;
        }
    }

    public static final double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static final float parseFloat(StringBuilder value) {
        try {
            return Float.parseFloat(value.toString());
        }
        catch (NumberFormatException e) {
            return Float.NaN;
        }
    }

    public static final double parseDouble(StringBuilder value) {
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static final int readLength(Reader reader) throws IOException {
        return ValueReader.readInt(reader, 34);
    }

    public static final int readCount(Reader reader) throws IOException {
        return ValueReader.readInt(reader, 123);
    }

    public static final StringBuilder readUntil(Reader reader, int tag) throws IOException {
        InputStream stream = reader.stream;
        StringBuilder sb = new StringBuilder();
        int i = stream.read();
        while (i != tag && i != -1) {
            sb.append((char)i);
            i = stream.read();
        }
        return sb;
    }

    public static final char[] readChars(Reader reader) throws IOException {
        int len = ValueReader.readLength(reader);
        char[] buf = new char[len];
        InputStream stream = reader.stream;
        block6: for (int i = 0; i < len; ++i) {
            int b1 = stream.read();
            switch (b1 >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[i] = (char)b1;
                    continue block6;
                }
                case 12: 
                case 13: {
                    int b2 = stream.read();
                    buf[i] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    int b2 = stream.read();
                    int b3 = stream.read();
                    buf[i] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                    continue block6;
                }
                case 15: {
                    int b4;
                    int s;
                    int b3;
                    int b2;
                    if ((b1 & 0xF) <= 4 && 0 <= (s = ((b1 & 7) << 18 | ((b2 = stream.read()) & 0x3F) << 12 | ((b3 = stream.read()) & 0x3F) << 6 | (b4 = stream.read()) & 0x3F) - 65536) && s <= 1048575) {
                        buf[i] = (char)(s >> 10 & 0x3FF | 0xD800);
                        buf[++i] = (char)(s & 0x3FF | 0xDC00);
                        continue block6;
                    }
                }
                default: {
                    throw ValueReader.badEncoding(b1);
                }
            }
        }
        reader.skip(34);
        return buf;
    }

    public static final char readChar(Reader reader) throws IOException {
        char u;
        InputStream stream = reader.stream;
        int b1 = stream.read();
        switch (b1 >>> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                u = (char)b1;
                break;
            }
            case 12: 
            case 13: {
                int b2 = stream.read();
                u = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                break;
            }
            case 14: {
                int b2 = stream.read();
                int b3 = stream.read();
                u = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                break;
            }
            default: {
                throw ValueReader.badEncoding(b1);
            }
        }
        return u;
    }

    public static final int readInt(Reader reader) throws IOException {
        return ValueReader.readInt(reader, 59);
    }

    public static final long readLong(Reader reader) throws IOException {
        return ValueReader.readLong(reader, 59);
    }

    public static final BigInteger readBigInteger(Reader reader) throws IOException {
        return new BigInteger(ValueReader.readUntil(reader, 59).toString(), 10);
    }

    public static final float readFloat(Reader reader) throws IOException {
        return ValueReader.parseFloat(ValueReader.readUntil(reader, 59));
    }

    public static final double readDouble(Reader reader) throws IOException {
        return ValueReader.parseDouble(ValueReader.readUntil(reader, 59));
    }

    public static final float readFloatInfinity(Reader reader) throws IOException {
        return reader.stream.read() == 45 ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
    }

    public static final double readInfinity(Reader reader) throws IOException {
        return reader.stream.read() == 45 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    public static final String readString(Reader reader) throws IOException {
        return new String(ValueReader.readChars(reader));
    }

    public static final String readUTF8Char(Reader reader) throws IOException {
        return new String(new char[]{ValueReader.readChar(reader)});
    }

    public static final byte[] readBytes(Reader reader) throws IOException {
        int size;
        int len;
        InputStream stream = reader.stream;
        int off = 0;
        byte[] b = new byte[len];
        for (len = ValueReader.readLength(reader); len > 0; len -= size) {
            size = stream.read(b, off, len);
            off += size;
        }
        reader.skip(34);
        return b;
    }

    private static int read4Digit(InputStream stream) throws IOException {
        int n = stream.read() - 48;
        n = n * 10 + stream.read() - 48;
        n = n * 10 + stream.read() - 48;
        return n * 10 + stream.read() - 48;
    }

    private static int read2Digit(InputStream stream) throws IOException {
        int n = stream.read() - 48;
        return n * 10 + stream.read() - 48;
    }

    public static final int readTime(Reader reader, DateTime dt) throws IOException {
        InputStream stream = reader.stream;
        dt.hour = ValueReader.read2Digit(stream);
        dt.minute = ValueReader.read2Digit(stream);
        dt.second = ValueReader.read2Digit(stream);
        int tag = stream.read();
        if (tag == 46) {
            dt.nanosecond = stream.read() - 48;
            dt.nanosecond = dt.nanosecond * 10 + (stream.read() - 48);
            dt.nanosecond = dt.nanosecond * 10 + (stream.read() - 48);
            dt.nanosecond *= 1000000;
            tag = stream.read();
            if (tag >= 48 && tag <= 57) {
                dt.nanosecond += (tag - 48) * 100000;
                dt.nanosecond += (stream.read() - 48) * 10000;
                dt.nanosecond += (stream.read() - 48) * 1000;
                tag = stream.read();
                if (tag >= 48 && tag <= 57) {
                    dt.nanosecond += (tag - 48) * 100;
                    dt.nanosecond += (stream.read() - 48) * 10;
                    dt.nanosecond += stream.read() - 48;
                    tag = stream.read();
                }
            }
        }
        return tag;
    }

    public static final DateTime readDateTime(Reader reader) throws IOException {
        InputStream stream = reader.stream;
        DateTime dt = new DateTime();
        dt.year = ValueReader.read4Digit(stream);
        dt.month = ValueReader.read2Digit(stream);
        dt.day = ValueReader.read2Digit(stream);
        int tag = stream.read();
        if (tag == 84) {
            tag = ValueReader.readTime(reader, dt);
        }
        dt.utc = tag == 90;
        return dt;
    }

    public static final DateTime readTime(Reader reader) throws IOException {
        DateTime dt = new DateTime();
        boolean bl = ValueReader.readTime(reader, dt) == 90;
        dt.utc = bl;
        return dt;
    }

    public static final UUID readUUID(Reader reader) throws IOException {
        InputStream stream = reader.stream;
        reader.skip(123);
        char[] buf = new char[36];
        for (int i = 0; i < 36; ++i) {
            buf[i] = (char)stream.read();
        }
        reader.skip(125);
        UUID uuid = UUID.fromString(new String(buf));
        return uuid;
    }
}

