/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public class LongObjectUnserializer
extends BaseUnserializer<Long> {
    public static final LongObjectUnserializer instance = new LongObjectUnserializer();

    @Override
    public Long unserialize(Reader reader, int tag, Type type) throws IOException {
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105 || tag == 108) {
            return ValueReader.readLong(reader, 59);
        }
        switch (tag) {
            case 100: {
                return Double.valueOf(ValueReader.readDouble(reader)).longValue();
            }
            case 101: {
                return 0L;
            }
            case 116: {
                return 1L;
            }
            case 102: {
                return 0L;
            }
            case 68: {
                return ReferenceReader.readDateTime(reader).toLong();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toLong();
            }
            case 117: {
                return Long.parseLong(ValueReader.readUTF8Char(reader));
            }
            case 115: {
                return Long.parseLong(ReferenceReader.readString(reader));
            }
        }
        return (Long)super.unserialize(reader, tag, type);
    }

    public Long read(Reader reader) throws IOException {
        return (Long)this.read(reader, (Type)((Object)Long.class));
    }
}

