/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public class DoubleObjectUnserializer
extends BaseUnserializer<Double> {
    public static final DoubleObjectUnserializer instance = new DoubleObjectUnserializer();

    @Override
    public Double unserialize(Reader reader, int tag, Type type) throws IOException {
        if (tag == 100) {
            return ValueReader.readDouble(reader);
        }
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(reader, 59);
        }
        switch (tag) {
            case 108: {
                return ValueReader.readLongAsDouble(reader);
            }
            case 101: {
                return 0.0;
            }
            case 116: {
                return 1.0;
            }
            case 102: {
                return 0.0;
            }
            case 78: {
                return Double.NaN;
            }
            case 73: {
                return ValueReader.readInfinity(reader);
            }
            case 117: {
                return ValueReader.parseDouble(ValueReader.readUTF8Char(reader));
            }
            case 115: {
                return ValueReader.parseDouble(ReferenceReader.readString(reader));
            }
        }
        return (Double)super.unserialize(reader, tag, type);
    }

    public Double read(Reader reader) throws IOException {
        return (Double)this.read(reader, (Type)((Object)Double.class));
    }
}

