/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public final class DateTimeUnserializer
extends BaseUnserializer<Date> {
    public static final DateTimeUnserializer instance = new DateTimeUnserializer();

    @Override
    public Date unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 68: {
                return ReferenceReader.readDateTime(reader).toDateTime();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toDateTime();
            }
            case 101: {
                return null;
            }
            case 115: {
                return new Date(ReferenceReader.readString(reader));
            }
            case 105: 
            case 108: {
                return new Date(ValueReader.readLong(reader));
            }
            case 100: {
                return new Date((long)ValueReader.readDouble(reader));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Date(tag - 48);
        }
        return (Date)super.unserialize(reader, tag, type);
    }

    public Date read(Reader reader) throws IOException {
        return (Date)this.read(reader, (Type)((Object)Date.class));
    }
}

