/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public class ByteObjectUnserializer
extends BaseUnserializer<Byte> {
    public static final ByteObjectUnserializer instance = new ByteObjectUnserializer();

    @Override
    public Byte unserialize(Reader reader, int tag, Type type) throws IOException {
        if (tag >= 48 && tag <= 57) {
            return (byte)(tag - 48);
        }
        if (tag == 105) {
            return (byte)ValueReader.readInt(reader, 59);
        }
        switch (tag) {
            case 108: {
                return (byte)ValueReader.readLong(reader, 59);
            }
            case 100: {
                return Double.valueOf(ValueReader.readDouble(reader)).byteValue();
            }
            case 101: {
                return (byte)0;
            }
            case 116: {
                return (byte)1;
            }
            case 102: {
                return (byte)0;
            }
            case 117: {
                return Byte.parseByte(ValueReader.readUTF8Char(reader));
            }
            case 115: {
                return Byte.parseByte(ReferenceReader.readString(reader));
            }
        }
        return (Byte)super.unserialize(reader, tag, type);
    }

    public Byte read(Reader reader) throws IOException {
        return (Byte)this.read(reader, (Type)((Object)Byte.class));
    }
}

