/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public final class ByteArrayUnserializer
extends BaseUnserializer<byte[]> {
    public static final ByteArrayUnserializer instance = new ByteArrayUnserializer();

    @Override
    public byte[] unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 101: {
                return new byte[0];
            }
            case 98: {
                return ReferenceReader.readBytes(reader);
            }
            case 97: {
                return ReferenceReader.readByteArray(reader);
            }
            case 117: {
                return ValueReader.readUTF8Char(reader).getBytes("UTF-8");
            }
            case 115: {
                return ReferenceReader.readString(reader).getBytes("UTF-8");
            }
        }
        return (byte[])super.unserialize(reader, tag, type);
    }

    public byte[] read(Reader reader) throws IOException {
        return (byte[])this.read(reader, (Type)((Object)byte[].class));
    }
}

