/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.hasor.rsf.hprose.io.HproseMode;
import net.hasor.rsf.hprose.io.serialize.AtomicIntegerArraySerializer;
import net.hasor.rsf.hprose.io.serialize.AtomicLongArraySerializer;
import net.hasor.rsf.hprose.io.serialize.AtomicReferenceArraySerializer;
import net.hasor.rsf.hprose.io.serialize.BigDecimalArraySerializer;
import net.hasor.rsf.hprose.io.serialize.BigIntegerArraySerializer;
import net.hasor.rsf.hprose.io.serialize.BooleanArraySerializer;
import net.hasor.rsf.hprose.io.serialize.ByteArraySerializer;
import net.hasor.rsf.hprose.io.serialize.BytesArraySerializer;
import net.hasor.rsf.hprose.io.serialize.CalendarArraySerializer;
import net.hasor.rsf.hprose.io.serialize.CalendarSerializer;
import net.hasor.rsf.hprose.io.serialize.CharArraySerializer;
import net.hasor.rsf.hprose.io.serialize.CharsArraySerializer;
import net.hasor.rsf.hprose.io.serialize.CollectionSerializer;
import net.hasor.rsf.hprose.io.serialize.DateArraySerializer;
import net.hasor.rsf.hprose.io.serialize.DateSerializer;
import net.hasor.rsf.hprose.io.serialize.DateTimeArraySerializer;
import net.hasor.rsf.hprose.io.serialize.DateTimeSerializer;
import net.hasor.rsf.hprose.io.serialize.DoubleArraySerializer;
import net.hasor.rsf.hprose.io.serialize.FloatArraySerializer;
import net.hasor.rsf.hprose.io.serialize.IntArraySerializer;
import net.hasor.rsf.hprose.io.serialize.ListSerializer;
import net.hasor.rsf.hprose.io.serialize.LongArraySerializer;
import net.hasor.rsf.hprose.io.serialize.MapSerializer;
import net.hasor.rsf.hprose.io.serialize.ObjectArraySerializer;
import net.hasor.rsf.hprose.io.serialize.OtherTypeArraySerializer;
import net.hasor.rsf.hprose.io.serialize.OtherTypeSerializer;
import net.hasor.rsf.hprose.io.serialize.SerializerFactory;
import net.hasor.rsf.hprose.io.serialize.ShortArraySerializer;
import net.hasor.rsf.hprose.io.serialize.StringArraySerializer;
import net.hasor.rsf.hprose.io.serialize.StringBufferArraySerializer;
import net.hasor.rsf.hprose.io.serialize.StringBufferSerializer;
import net.hasor.rsf.hprose.io.serialize.StringBuilderArraySerializer;
import net.hasor.rsf.hprose.io.serialize.StringBuilderSerializer;
import net.hasor.rsf.hprose.io.serialize.StringSerializer;
import net.hasor.rsf.hprose.io.serialize.TimeArraySerializer;
import net.hasor.rsf.hprose.io.serialize.TimeSerializer;
import net.hasor.rsf.hprose.io.serialize.TimestampArraySerializer;
import net.hasor.rsf.hprose.io.serialize.TimestampSerializer;
import net.hasor.rsf.hprose.io.serialize.UUIDArraySerializer;
import net.hasor.rsf.hprose.io.serialize.UUIDSerializer;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.WriterRefer;

public class Writer {
    public final OutputStream stream;
    final WriterRefer refer;
    final HproseMode mode;
    final HashMap<Class<?>, Integer> classref = new HashMap();
    int lastclassref = 0;

    public Writer(OutputStream stream) {
        this(stream, HproseMode.MemberMode, false);
    }

    public Writer(OutputStream stream, boolean simple) {
        this(stream, HproseMode.MemberMode, simple);
    }

    public Writer(OutputStream stream, HproseMode mode) {
        this(stream, mode, false);
    }

    public Writer(OutputStream stream, HproseMode mode, boolean simple) {
        this.stream = stream;
        this.mode = mode;
        this.refer = simple ? null : new WriterRefer();
    }

    public final void serialize(Object obj) throws IOException {
        if (obj == null) {
            this.stream.write(110);
        } else {
            SerializerFactory.get(obj.getClass()).write(this, obj);
        }
    }

    public final void writeInteger(int i) throws IOException {
        ValueWriter.write(this.stream, i);
    }

    public final void writeLong(long l) throws IOException {
        ValueWriter.write(this.stream, l);
    }

    public final void writeBigInteger(BigInteger bi) throws IOException {
        ValueWriter.write(this.stream, bi);
    }

    public final void writeFloat(float f) throws IOException {
        ValueWriter.write(this.stream, f);
    }

    public final void writeDouble(double d) throws IOException {
        ValueWriter.write(this.stream, d);
    }

    public final void writeBigDecimal(BigDecimal bd) throws IOException {
        ValueWriter.write(this.stream, bd);
    }

    public final void writeNaN() throws IOException {
        this.stream.write(78);
    }

    public final void writeInfinity(boolean positive) throws IOException {
        this.stream.write(73);
        this.stream.write(positive ? 43 : 45);
    }

    public final void writeNull() throws IOException {
        this.stream.write(110);
    }

    public final void writeEmpty() throws IOException {
        this.stream.write(101);
    }

    public final void writeBoolean(boolean b) throws IOException {
        this.stream.write(b ? 116 : 102);
    }

    public final void writeDate(Date date) throws IOException {
        DateSerializer.instance.serialize(this, date);
    }

    public final void writeDateWithRef(Date date) throws IOException {
        DateSerializer.instance.write(this, date);
    }

    public final void writeDate(Time time) throws IOException {
        TimeSerializer.instance.serialize(this, time);
    }

    public final void writeDateWithRef(Time time) throws IOException {
        TimeSerializer.instance.write(this, time);
    }

    public final void writeDate(Timestamp time) throws IOException {
        TimestampSerializer.instance.serialize(this, time);
    }

    public final void writeDateWithRef(Timestamp time) throws IOException {
        TimestampSerializer.instance.write(this, time);
    }

    public final void writeDate(java.util.Date date) throws IOException {
        DateTimeSerializer.instance.serialize(this, date);
    }

    public final void writeDateWithRef(java.util.Date date) throws IOException {
        DateTimeSerializer.instance.write(this, date);
    }

    public final void writeDate(Calendar calendar) throws IOException {
        CalendarSerializer.instance.serialize(this, calendar);
    }

    public final void writeDateWithRef(Calendar calendar) throws IOException {
        CalendarSerializer.instance.write(this, calendar);
    }

    public final void writeTime(Time time) throws IOException {
        this.writeDate(time);
    }

    public final void writeTimeWithRef(Time time) throws IOException {
        this.writeDateWithRef(time);
    }

    public final void writeBytes(byte[] bytes) throws IOException {
        ByteArraySerializer.instance.serialize(this, bytes);
    }

    public final void writeBytesWithRef(byte[] bytes) throws IOException {
        ByteArraySerializer.instance.write(this, bytes);
    }

    public final void writeUTF8Char(char c) throws IOException {
        ValueWriter.write(this.stream, c);
    }

    public final void writeString(String s) throws IOException {
        StringSerializer.instance.serialize(this, s);
    }

    public final void writeStringWithRef(String s) throws IOException {
        StringSerializer.instance.write(this, s);
    }

    public final void writeString(StringBuilder s) throws IOException {
        StringBuilderSerializer.instance.serialize(this, s);
    }

    public final void writeStringWithRef(StringBuilder s) throws IOException {
        StringBuilderSerializer.instance.write(this, s);
    }

    public final void writeString(StringBuffer s) throws IOException {
        StringBufferSerializer.instance.serialize(this, s);
    }

    public final void writeStringWithRef(StringBuffer s) throws IOException {
        StringBufferSerializer.instance.write(this, s);
    }

    public final void writeString(char[] s) throws IOException {
        CharArraySerializer.instance.serialize(this, s);
    }

    public final void writeStringWithRef(char[] s) throws IOException {
        CharArraySerializer.instance.write(this, s);
    }

    public final void writeUUID(UUID uuid) throws IOException {
        UUIDSerializer.instance.serialize(this, uuid);
    }

    public final void writeUUIDWithRef(UUID uuid) throws IOException {
        UUIDSerializer.instance.write(this, uuid);
    }

    public final void writeArray(short[] array) throws IOException {
        ShortArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(short[] array) throws IOException {
        ShortArraySerializer.instance.write(this, array);
    }

    public final void writeArray(int[] array) throws IOException {
        IntArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(int[] array) throws IOException {
        IntArraySerializer.instance.write(this, array);
    }

    public final void writeArray(long[] array) throws IOException {
        LongArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(long[] array) throws IOException {
        LongArraySerializer.instance.write(this, array);
    }

    public final void writeArray(float[] array) throws IOException {
        FloatArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(float[] array) throws IOException {
        FloatArraySerializer.instance.write(this, array);
    }

    public final void writeArray(double[] array) throws IOException {
        DoubleArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(double[] array) throws IOException {
        DoubleArraySerializer.instance.write(this, array);
    }

    public final void writeArray(boolean[] array) throws IOException {
        BooleanArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(boolean[] array) throws IOException {
        BooleanArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Date[] array) throws IOException {
        DateArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(Date[] array) throws IOException {
        DateArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Time[] array) throws IOException {
        TimeArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(Time[] array) throws IOException {
        TimeArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Timestamp[] array) throws IOException {
        TimestampArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(Timestamp[] array) throws IOException {
        TimestampArraySerializer.instance.write(this, array);
    }

    public final void writeArray(java.util.Date[] array) throws IOException {
        DateTimeArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(java.util.Date[] array) throws IOException {
        DateTimeArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Calendar[] array) throws IOException {
        CalendarArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(Calendar[] array) throws IOException {
        CalendarArraySerializer.instance.write(this, array);
    }

    public final void writeArray(String[] array) throws IOException {
        StringArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(String[] array) throws IOException {
        StringArraySerializer.instance.write(this, array);
    }

    public final void writeArray(StringBuilder[] array) throws IOException {
        StringBuilderArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(StringBuilder[] array) throws IOException {
        StringBuilderArraySerializer.instance.write(this, array);
    }

    public final void writeArray(StringBuffer[] array) throws IOException {
        StringBufferArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(StringBuffer[] array) throws IOException {
        StringBufferArraySerializer.instance.write(this, array);
    }

    public final void writeArray(UUID[] array) throws IOException {
        UUIDArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(UUID[] array) throws IOException {
        UUIDArraySerializer.instance.write(this, array);
    }

    public final void writeArray(char[][] array) throws IOException {
        CharsArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(char[][] array) throws IOException {
        CharsArraySerializer.instance.write(this, array);
    }

    public final void writeArray(byte[][] array) throws IOException {
        BytesArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(byte[][] array) throws IOException {
        BytesArraySerializer.instance.write(this, array);
    }

    public final void writeArray(BigInteger[] array) throws IOException {
        BigIntegerArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(BigInteger[] array) throws IOException {
        BigIntegerArraySerializer.instance.write(this, array);
    }

    public final void writeArray(BigDecimal[] array) throws IOException {
        BigDecimalArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(BigDecimal[] array) throws IOException {
        BigDecimalArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Object[] array) throws IOException {
        ObjectArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(Object[] array) throws IOException {
        ObjectArraySerializer.instance.write(this, array);
    }

    public final void writeArray(AtomicIntegerArray array) throws IOException {
        AtomicIntegerArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(AtomicIntegerArray array) throws IOException {
        AtomicIntegerArraySerializer.instance.write(this, array);
    }

    public final void writeArray(AtomicLongArray array) throws IOException {
        AtomicLongArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(AtomicLongArray array) throws IOException {
        AtomicLongArraySerializer.instance.write(this, array);
    }

    public final void writeArray(AtomicReferenceArray array) throws IOException {
        AtomicReferenceArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(AtomicReferenceArray array) throws IOException {
        AtomicReferenceArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Object array) throws IOException {
        OtherTypeArraySerializer.instance.serialize(this, array);
    }

    public final void writeArrayWithRef(Object array) throws IOException {
        OtherTypeArraySerializer.instance.write(this, array);
    }

    public final void writeCollection(Collection<?> collection) throws IOException {
        CollectionSerializer.instance.serialize(this, collection);
    }

    public final void writeCollectionWithRef(Collection<?> collection) throws IOException {
        CollectionSerializer.instance.write(this, collection);
    }

    public final void writeList(List<?> list) throws IOException {
        ListSerializer.instance.serialize(this, list);
    }

    public final void writeListWithRef(List<?> list) throws IOException {
        ListSerializer.instance.write(this, list);
    }

    public final void writeMap(Map<?, ?> map) throws IOException {
        MapSerializer.instance.write(this, map);
    }

    public final void writeMapWithRef(Map<?, ?> map) throws IOException {
        MapSerializer.instance.write(this, map);
    }

    public final void writeObject(Object object) throws IOException {
        OtherTypeSerializer.instance.serialize(this, object);
    }

    public final void writeObjectWithRef(Object object) throws IOException {
        OtherTypeSerializer.instance.write(this, object);
    }

    final boolean writeRef(Object object) throws IOException {
        return this.refer != null && this.refer.write(this.stream, object);
    }

    final void setRef(Object object) {
        if (this.refer != null) {
            this.refer.set(object);
        }
    }

    public final void reset() {
        if (this.refer != null) {
            this.refer.reset();
        }
        this.classref.clear();
        this.lastclassref = 0;
    }
}

