/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import net.hasor.rsf.hprose.io.serialize.ReferenceSerializer;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;

public final class ListSerializer<T>
extends ReferenceSerializer<List<T>> {
    public static final ListSerializer instance = new ListSerializer();

    @Override
    public final void serialize(Writer writer, List<T> list) throws IOException {
        super.serialize(writer, list);
        OutputStream stream = writer.stream;
        stream.write(97);
        int count = list.size();
        if (count > 0) {
            ValueWriter.writeInt(stream, count);
        }
        stream.write(123);
        if (list instanceof RandomAccess) {
            for (int i = 0; i < count; ++i) {
                writer.serialize(list.get(i));
            }
        } else {
            Iterator<T> i = list.iterator();
            while (i.hasNext()) {
                writer.serialize(i.next());
            }
        }
        stream.write(125);
    }
}

