/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.TimeZone;
import net.hasor.rsf.hprose.io.serialize.ReferenceSerializer;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;
import net.hasor.rsf.hprose.util.TimeZoneUtil;

public final class CalendarSerializer
extends ReferenceSerializer<Calendar> {
    public static final CalendarSerializer instance = new CalendarSerializer();

    @Override
    public final void serialize(Writer writer, Calendar calendar) throws IOException {
        super.serialize(writer, calendar);
        TimeZone tz = calendar.getTimeZone();
        if (!tz.hasSameRules(TimeZoneUtil.DefaultTZ) && !tz.hasSameRules(TimeZoneUtil.UTC)) {
            tz = TimeZoneUtil.UTC;
            Calendar c = (Calendar)calendar.clone();
            c.setTimeZone(tz);
            calendar = c;
        }
        OutputStream stream = writer.stream;
        ValueWriter.writeDateOfCalendar(stream, calendar);
        ValueWriter.writeTimeOfCalendar(stream, calendar, true, false);
        stream.write(tz.hasSameRules(TimeZoneUtil.UTC) ? 90 : 59);
    }
}

