/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.convert.java8;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import net.hasor.rsf.hprose.io.convert.Converter;
import net.hasor.rsf.hprose.util.DateTime;
import net.hasor.rsf.hprose.util.TimeZoneUtil;

public class InstantConverter
implements Converter<Instant> {
    public static final InstantConverter instance = new InstantConverter();

    public Instant convertTo(DateTime dt) {
        return OffsetDateTime.of(dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second, dt.nanosecond, dt.utc ? ZoneOffset.UTC : ZoneOffset.of(TimeZoneUtil.DefaultTZ.getID())).toInstant();
    }

    public Instant convertTo(String str) {
        return Instant.parse(str);
    }

    public Instant convertTo(char[] chars) {
        return Instant.parse(new String(chars));
    }

    public Instant convertTo(long milli) {
        return Instant.ofEpochMilli(milli);
    }

    public Instant convertTo(double milli) {
        return Instant.ofEpochMilli((long)milli);
    }

    @Override
    public Instant convertTo(Object obj, Type type) {
        if (obj instanceof DateTime) {
            return this.convertTo((DateTime)obj);
        }
        if (obj instanceof String) {
            return Instant.parse((String)obj);
        }
        if (obj instanceof char[]) {
            return Instant.parse(new String((char[])obj));
        }
        if (obj instanceof Long) {
            return Instant.ofEpochMilli((Long)obj);
        }
        if (obj instanceof Double) {
            return Instant.ofEpochMilli(((Double)obj).longValue());
        }
        return (Instant)obj;
    }
}

