/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.access;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.common.HproseException;
import net.hasor.rsf.hprose.io.access.MemberAccessor;
import net.hasor.rsf.hprose.io.serialize.Serializer;
import net.hasor.rsf.hprose.io.serialize.SerializerFactory;
import net.hasor.rsf.hprose.io.serialize.Writer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.Unserializer;
import net.hasor.rsf.hprose.io.unserialize.UnserializerFactory;
import net.hasor.rsf.hprose.util.ClassUtil;

public final class SafeFieldAccessor
implements MemberAccessor {
    private final Field field;
    private final Type fieldType;
    private final Serializer serializer;
    private final Unserializer unserializer;

    public SafeFieldAccessor(Type type, Field field) {
        field.setAccessible(true);
        this.field = field;
        this.fieldType = ClassUtil.getActualType(type, field.getGenericType());
        Class<?> cls = ClassUtil.toClass(this.fieldType);
        this.serializer = SerializerFactory.get(cls);
        this.unserializer = UnserializerFactory.get(cls);
    }

    @Override
    public void serialize(Writer writer, Object obj) throws IOException {
        Object value;
        try {
            value = this.field.get(obj);
        }
        catch (Exception e) {
            throw new HproseException(e);
        }
        if (value == null) {
            writer.stream.write(110);
        } else {
            this.serializer.write(writer, value);
        }
    }

    @Override
    public void unserialize(Reader reader, Object obj) throws IOException {
        Object value = this.unserializer.read(reader, reader.stream.read(), this.fieldType);
        try {
            this.field.set(obj, value);
        }
        catch (Exception e) {
            throw new HproseException(e);
        }
    }
}

