/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.access;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.common.HproseException;
import net.hasor.rsf.hprose.io.access.MemberAccessor;
import net.hasor.rsf.hprose.io.serialize.Serializer;
import net.hasor.rsf.hprose.io.serialize.SerializerFactory;
import net.hasor.rsf.hprose.io.serialize.Writer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.Unserializer;
import net.hasor.rsf.hprose.io.unserialize.UnserializerFactory;
import net.hasor.rsf.hprose.util.ClassUtil;

public final class PropertyAccessor
implements MemberAccessor {
    private static final Object[] nullArgs = new Object[0];
    private final Method getter;
    private final Method setter;
    private final Type propType;
    private final Serializer serializer;
    private final Unserializer unserializer;

    public PropertyAccessor(Type type, Method getter, Method setter) {
        getter.setAccessible(true);
        setter.setAccessible(true);
        this.getter = getter;
        this.setter = setter;
        this.propType = ClassUtil.getActualType(type, getter.getGenericReturnType());
        Class<?> cls = ClassUtil.toClass(this.propType);
        this.serializer = SerializerFactory.get(cls);
        this.unserializer = UnserializerFactory.get(cls);
    }

    @Override
    public void serialize(Writer writer, Object obj) throws IOException {
        Object value;
        try {
            value = this.getter.invoke(obj, nullArgs);
        }
        catch (Exception e) {
            throw new HproseException(e);
        }
        if (value == null) {
            writer.stream.write(110);
        } else {
            this.serializer.write(writer, value);
        }
    }

    @Override
    public void unserialize(Reader reader, Object obj) throws IOException {
        Object value = this.unserializer.read(reader, reader.stream.read(), this.propType);
        try {
            this.setter.invoke(obj, value);
        }
        catch (Exception e) {
            throw new HproseException(e);
        }
    }
}

