/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.access;

import java.io.IOException;
import java.lang.reflect.Field;
import net.hasor.rsf.hprose.common.HproseException;
import net.hasor.rsf.hprose.io.access.Accessors;
import net.hasor.rsf.hprose.io.access.MemberAccessor;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;
import net.hasor.rsf.hprose.io.unserialize.LongUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;

public final class LongFieldAccessor
implements MemberAccessor {
    private final long offset;

    public LongFieldAccessor(Field accessor) {
        accessor.setAccessible(true);
        this.offset = Accessors.unsafe.objectFieldOffset(accessor);
    }

    @Override
    public void serialize(Writer writer, Object obj) throws IOException {
        long value;
        try {
            value = Accessors.unsafe.getLong(obj, this.offset);
        }
        catch (Exception e) {
            throw new HproseException(e);
        }
        ValueWriter.write(writer.stream, value);
    }

    @Override
    public void unserialize(Reader reader, Object obj) throws IOException {
        long value = LongUnserializer.instance.read(reader);
        try {
            Accessors.unsafe.putLong(obj, this.offset, value);
        }
        catch (Exception e) {
            throw new HproseException(e);
        }
    }
}

