/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.rsf.hprose.client.HproseTcpClient;
import net.hasor.rsf.hprose.client.Request;
import net.hasor.rsf.hprose.net.Connection;
import net.hasor.rsf.hprose.net.ConnectionHandler;
import net.hasor.rsf.hprose.net.Connector;
import net.hasor.rsf.hprose.util.concurrent.Promise;
import net.hasor.rsf.hprose.util.concurrent.Threads;

abstract class SocketTransporter
implements ConnectionHandler {
    protected final HproseTcpClient client;
    protected final LinkedList<Connection> idleConnections = new LinkedList();
    protected final ConcurrentLinkedQueue<Request> requests = new ConcurrentLinkedQueue();
    protected final AtomicInteger size = new AtomicInteger(0);

    public SocketTransporter(HproseTcpClient client) {
        this.client = client;
    }

    @Override
    public final int getReadTimeout() {
        return this.client.getReadTimeout();
    }

    @Override
    public final int getWriteTimeout() {
        return this.client.getWriteTimeout();
    }

    @Override
    public final int getConnectTimeout() {
        return this.client.getConnectTimeout();
    }

    protected final void create(Request request) {
        if (this.size.get() < this.client.getMaxPoolSize()) {
            try {
                ConnectorHolder.create(this.client.uri, this, this.client.isKeepAlive(), this.client.isNoDelay());
            }
            catch (IOException ex) {
                request.result.reject(ex);
                return;
            }
        }
        this.requests.offer(request);
    }

    protected abstract Connection fetch(Request var1);

    protected abstract void send(Connection var1, Request var2);

    public final Promise<ByteBuffer> send(ByteBuffer buffer, int timeout) {
        Request request = new Request(buffer, timeout);
        Connection conn = this.fetch(request);
        if (conn != null) {
            this.send(conn, request);
        }
        return request.result;
    }

    protected void close(Set<Connection> conns) {
        while (!conns.isEmpty()) {
            for (Connection conn : conns) {
                conn.close();
            }
        }
        while (!this.requests.isEmpty()) {
            this.requests.poll().result.reject(new ClosedChannelException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onClose(Connection conn) {
        this.size.decrementAndGet();
        LinkedList<Connection> linkedList = this.idleConnections;
        synchronized (linkedList) {
            this.idleConnections.remove(conn);
        }
        this.onError(conn, new ClosedChannelException());
    }

    public abstract void close();

    protected static final class ConnectorHolder {
        private static volatile Connector connector;

        protected ConnectorHolder() {
        }

        private static void init() {
            Connector temp = null;
            try {
                temp = new Connector(HproseTcpClient.getReactorThreads());
            }
            catch (IOException iOException) {
            }
            finally {
                connector = temp;
            }
        }

        public static final void create(String uri, ConnectionHandler handler, boolean keepAlive, boolean noDelay) throws IOException {
            if (!connector.isAlive()) {
                try {
                    connector.start();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
            connector.create(uri, handler, keepAlive, noDelay);
        }

        static {
            ConnectorHolder.init();
            Threads.registerShutdownHandler(new Runnable(){

                @Override
                public void run() {
                    Connector temp = connector;
                    ConnectorHolder.init();
                    if (temp != null) {
                        temp.close();
                    }
                }
            });
        }
    }
}

