/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.client;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import net.hasor.rsf.hprose.client.HproseTcpClient;
import net.hasor.rsf.hprose.client.Request;
import net.hasor.rsf.hprose.client.Response;
import net.hasor.rsf.hprose.client.SocketTransporter;
import net.hasor.rsf.hprose.net.Connection;
import net.hasor.rsf.hprose.net.TimeoutType;
import net.hasor.rsf.hprose.util.concurrent.Promise;
import net.hasor.rsf.hprose.util.concurrent.Timer;

final class HalfDuplexSocketTransporter
extends SocketTransporter {
    private final Map<Connection, Response> responses = new ConcurrentHashMap<Connection, Response>();

    public HalfDuplexSocketTransporter(HproseTcpClient client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Connection fetch(Request request) {
        Connection conn;
        LinkedList linkedList = this.idleConnections;
        synchronized (linkedList) {
            while ((conn = (Connection)this.idleConnections.poll()) != null && !conn.isConnected()) {
            }
            if (conn != null) {
                conn.clearTimeout();
            } else {
                this.create(request);
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle(Connection conn) {
        LinkedList linkedList = this.idleConnections;
        synchronized (linkedList) {
            if (!this.idleConnections.contains(conn)) {
                this.idleConnections.offer(conn);
                conn.setTimeout(this.client.getIdleTimeout(), TimeoutType.IDLE_TIMEOUT);
            }
        }
    }

    private Promise<ByteBuffer> clean(Connection conn) {
        Response response = this.responses.remove(conn);
        if (response != null) {
            response.timer.clear();
            return response.result;
        }
        return null;
    }

    private void sendNext(Connection conn) {
        Request request = (Request)this.requests.poll();
        if (request != null) {
            this.send(conn, request);
        } else {
            this.recycle(conn);
        }
    }

    @Override
    protected final void send(final Connection conn, Request request) {
        Timer timer = new Timer(new Runnable(){

            @Override
            public void run() {
                Promise result = HalfDuplexSocketTransporter.this.clean(conn);
                conn.close();
                if (result != null) {
                    result.reject(new TimeoutException("timeout"));
                }
            }
        });
        timer.setTimeout(request.timeout);
        this.responses.put(conn, new Response(request.result, timer));
        conn.send(request.buffer, null);
    }

    @Override
    public final void close() {
        this.close(this.responses.keySet());
    }

    @Override
    public final void onConnect(Connection conn) {
        this.size.incrementAndGet();
    }

    @Override
    public final void onConnected(Connection conn) {
        this.sendNext(conn);
    }

    @Override
    public final void onTimeout(Connection conn, TimeoutType type) {
        Response response;
        if (TimeoutType.CONNECT_TIMEOUT == type) {
            Request request;
            this.responses.remove(conn);
            while ((request = (Request)this.requests.poll()) != null) {
                request.result.reject(new TimeoutException("connect timeout"));
            }
        } else if (TimeoutType.IDLE_TIMEOUT != type && (response = this.responses.remove(conn)) != null) {
            response.timer.clear();
            response.result.reject(new TimeoutException(type.toString()));
        }
        conn.close();
    }

    @Override
    public final void onReceived(Connection conn, ByteBuffer data, Integer id) {
        Promise<ByteBuffer> result = this.clean(conn);
        if (result != null) {
            if (data.position() != 0) {
                data.flip();
            }
            result.resolve((Object)data);
        }
        this.sendNext(conn);
    }

    @Override
    public final void onSended(Connection conn, ByteBuffer data, Integer id) {
    }

    @Override
    public final void onError(Connection conn, Exception e) {
        Response response = this.responses.remove(conn);
        if (response != null) {
            response.timer.clear();
            response.result.reject(e);
        }
    }
}

