/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hessian.hessian.client;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hasor.rsf.hessian.hessian.client.HessianConnection;
import net.hasor.rsf.hessian.hessian.client.HessianConnectionFactory;
import net.hasor.rsf.hessian.hessian.client.HessianProxyFactory;
import net.hasor.rsf.hessian.hessian.client.HessianURLConnection;

public class HessianURLConnectionFactory
implements HessianConnectionFactory {
    private static final Logger log = Logger.getLogger(HessianURLConnectionFactory.class.getName());
    private HessianProxyFactory _proxyFactory;

    @Override
    public void setHessianProxyFactory(HessianProxyFactory factory) {
        this._proxyFactory = factory;
    }

    @Override
    public HessianConnection open(URL url) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " open(" + url + ")");
        }
        URLConnection conn = url.openConnection();
        long connectTimeout = this._proxyFactory.getConnectTimeout();
        if (connectTimeout >= 0L) {
            conn.setConnectTimeout((int)connectTimeout);
        }
        conn.setDoOutput(true);
        long readTimeout = this._proxyFactory.getReadTimeout();
        if (readTimeout > 0L) {
            try {
                conn.setReadTimeout((int)readTimeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new HessianURLConnection(url, conn);
    }
}

