/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hessian.hessian.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import net.hasor.rsf.hessian.hessian.client.AbstractHessianConnection;
import net.hasor.rsf.hessian.hessian.client.HessianConnectionException;

public class HessianURLConnection
extends AbstractHessianConnection {
    private URL _url;
    private URLConnection _conn;
    private int _statusCode;
    private String _statusMessage;
    private InputStream _inputStream;
    private InputStream _errorStream;

    HessianURLConnection(URL url, URLConnection conn) {
        this._url = url;
        this._conn = conn;
    }

    @Override
    public void addHeader(String key, String value) {
        this._conn.setRequestProperty(key, value);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this._conn.getOutputStream();
    }

    @Override
    public void sendRequest() throws IOException {
        if (this._conn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)this._conn;
            this._statusCode = 500;
            try {
                this._statusCode = httpConn.getResponseCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.parseResponseHeaders(httpConn);
            InputStream is = null;
            if (this._statusCode != 200) {
                StringBuffer sb = new StringBuffer();
                try {
                    int ch;
                    is = httpConn.getInputStream();
                    if (is != null) {
                        while ((ch = is.read()) >= 0) {
                            sb.append((char)ch);
                        }
                        is.close();
                    }
                    if ((is = httpConn.getErrorStream()) != null) {
                        while ((ch = is.read()) >= 0) {
                            sb.append((char)ch);
                        }
                    }
                    this._statusMessage = sb.toString();
                }
                catch (FileNotFoundException e) {
                    throw new HessianConnectionException("HessianProxy cannot connect to '" + this._url, e);
                }
                catch (IOException e) {
                    if (is == null) {
                        throw new HessianConnectionException(this._statusCode + ": " + e, e);
                    }
                    throw new HessianConnectionException(this._statusCode + ": " + sb, e);
                }
                if (is != null) {
                    is.close();
                }
                throw new HessianConnectionException(this._statusCode + ": " + sb.toString());
            }
        }
    }

    protected void parseResponseHeaders(HttpURLConnection conn) throws IOException {
    }

    @Override
    public int getStatusCode() {
        return this._statusCode;
    }

    @Override
    public String getStatusMessage() {
        return this._statusMessage;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._conn.getInputStream();
    }

    @Override
    public String getContentEncoding() {
        return this._conn.getContentEncoding();
    }

    @Override
    public void close() {
        this._inputStream = null;
    }

    @Override
    public void destroy() {
        this.close();
        URLConnection conn = this._conn;
        this._conn = null;
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }
}

