/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.filters.local;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfFilter;
import net.hasor.rsf.RsfFilterChain;
import net.hasor.rsf.RsfRequest;
import net.hasor.rsf.RsfResponse;

public class LocalPref
implements RsfFilter {
    @Override
    public void doFilter(RsfRequest request, RsfResponse response, RsfFilterChain chain) throws Throwable {
        if (request.isLocal() && !request.isP2PCalls()) {
            RsfBindInfo<?> bindInfo = request.getBindInfo();
            Supplier<?> provider = request.getContext().getServiceProvider(bindInfo);
            if (provider != null) {
                String method = request.getMethod().getName();
                Class<?>[] rParams = request.getParameterTypes();
                Object[] rObjects = request.getParameterObject();
                Method m = provider.get().getClass().getMethod(method, rParams);
                try {
                    response.sendData(m.invoke(provider.get(), rObjects));
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

