/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.domain;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.hasor.core.info.MetaDataAdapter;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfMessage;
import net.hasor.rsf.domain.RsfServiceType;
import net.hasor.utils.StringUtils;

public class ServiceDomain<T>
extends MetaDataAdapter
implements RsfBindInfo<T> {
    private String bindID = null;
    private String bindName = null;
    private String bindGroup = "default";
    private String bindVersion = "1.0.0";
    private Map<String, String> aliasNameMap = null;
    private Class<T> bindType = null;
    private boolean asMessage = false;
    private boolean asShadow = false;
    private boolean isSharedThreadPool = true;
    private int clientTimeout = 6000;
    private String serializeType = null;
    private RsfServiceType serviceType = null;
    private Set<String> bindProtocols = null;

    public ServiceDomain(Class<T> bindType) {
        this.bindType = bindType;
        this.asMessage = bindType.isAnnotationPresent(RsfMessage.class);
        this.aliasNameMap = new HashMap<String, String>();
        this.bindProtocols = new HashSet<String>();
    }

    @Override
    public String getBindID() {
        if (this.bindID == null) {
            this.bindID = String.format("[%s]%s-%s", this.bindGroup, this.bindName, this.bindVersion);
        }
        return this.bindID;
    }

    @Override
    public String getBindName() {
        return this.bindName;
    }

    @Override
    public Set<String> getAliasTypes() {
        return Collections.unmodifiableSet(this.aliasNameMap.keySet());
    }

    public void setBindName(String bindName) {
        this.bindName = bindName;
    }

    @Override
    public String getBindGroup() {
        return this.bindGroup;
    }

    public void setBindGroup(String bindGroup) {
        this.bindGroup = bindGroup;
    }

    @Override
    public String getBindVersion() {
        return this.bindVersion;
    }

    public void setBindVersion(String bindVersion) {
        this.bindVersion = bindVersion;
    }

    @Override
    public String getAliasName(String aliasType) {
        return this.aliasNameMap.get(aliasType);
    }

    public void putAliasName(String aliasType, String aliasName) {
        aliasType = Objects.requireNonNull(aliasType, "aliasType is null.");
        aliasName = Objects.requireNonNull(aliasName, "aliasName is null.");
        this.aliasNameMap.put(aliasType, aliasName);
    }

    @Override
    public Class<T> getBindType() {
        return this.bindType;
    }

    @Override
    public boolean isMessage() {
        return this.asMessage || this.bindType.isAnnotationPresent(RsfMessage.class);
    }

    public void setMessage(boolean asMessage) {
        this.asMessage = asMessage;
    }

    @Override
    public boolean isShadow() {
        return this.asShadow;
    }

    public void setShadow(boolean asShadow) {
        this.asShadow = asShadow;
    }

    @Override
    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public void setClientTimeout(int clientTimeout) {
        this.clientTimeout = clientTimeout;
    }

    @Override
    public String getSerializeType() {
        return this.serializeType;
    }

    @Override
    public boolean isSharedThreadPool() {
        return this.isSharedThreadPool;
    }

    public void setSharedThreadPool(boolean sharedThreadPool) {
        this.isSharedThreadPool = sharedThreadPool;
    }

    public void setSerializeType(String serializeType) {
        this.serializeType = serializeType;
    }

    @Override
    public RsfServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(RsfServiceType serviceType) {
        this.serviceType = serviceType;
    }

    @Override
    public Set<String> getBindProtocols() {
        return this.bindProtocols;
    }

    public void addBindProtocol(String bindProtocol) {
        if (StringUtils.isBlank((String)bindProtocol)) {
            return;
        }
        this.bindProtocols.add(bindProtocol);
    }

    public String toString() {
        return "ServiceDomain{bindID='" + this.bindID + '\'' + ", bindName='" + this.bindName + '\'' + ", bindGroup='" + this.bindGroup + '\'' + ", bindVersion='" + this.bindVersion + '\'' + ", bindType=" + this.bindType + '}';
    }
}

