/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.domain;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import net.hasor.rsf.domain.RsfException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsfRuntimeUtils {
    protected static Logger logger = LoggerFactory.getLogger(RsfRuntimeUtils.class);
    private static AtomicLong requestID = new AtomicLong(1L);
    private static ConcurrentMap<String, Class<?>> classCache = new ConcurrentHashMap();
    private static ConcurrentMap<Class<?>, ConcurrentMap<String, Method>> methodCache = new ConcurrentHashMap();

    public static long genRequestID() {
        return requestID.incrementAndGet();
    }

    public static Class<?> toJavaType(String tType, ClassLoader loader) throws ClassNotFoundException {
        char atChar = tType.charAt(0);
        if ('I' == atChar) {
            return Integer.TYPE;
        }
        if ('B' == atChar) {
            return Byte.TYPE;
        }
        if ('C' == atChar) {
            return Character.TYPE;
        }
        if ('D' == atChar) {
            return Double.TYPE;
        }
        if ('F' == atChar) {
            return Float.TYPE;
        }
        if ('J' == atChar) {
            return Long.TYPE;
        }
        if ('S' == atChar) {
            return Short.TYPE;
        }
        if ('Z' == atChar) {
            return Boolean.TYPE;
        }
        if ('V' == atChar) {
            return Void.TYPE;
        }
        if (atChar == '[') {
            int length = 0;
            while (tType.charAt(length) == '[') {
                ++length;
            }
            String arrayType = tType.substring(length);
            Class<?> returnType = RsfRuntimeUtils.toJavaType(arrayType, loader);
            for (int i = 0; i < length; ++i) {
                Object obj = Array.newInstance(returnType, length);
                returnType = obj.getClass();
            }
            return returnType;
        }
        Class<?> cache = (Class<?>)classCache.get(tType);
        if (cache == null) {
            cache = loader.loadClass(tType);
            classCache.put(tType, cache);
        }
        return cache;
    }

    public static String toAsmType(Class<?> classType) {
        if (classType == Integer.TYPE) {
            return "I";
        }
        if (classType == Byte.TYPE) {
            return "B";
        }
        if (classType == Character.TYPE) {
            return "C";
        }
        if (classType == Double.TYPE) {
            return "D";
        }
        if (classType == Float.TYPE) {
            return "F";
        }
        if (classType == Long.TYPE) {
            return "J";
        }
        if (classType == Short.TYPE) {
            return "S";
        }
        if (classType == Boolean.TYPE) {
            return "Z";
        }
        if (classType == Void.TYPE) {
            return "V";
        }
        if (classType.isArray()) {
            return "[" + RsfRuntimeUtils.toAsmType(classType.getComponentType());
        }
        return classType.getName();
    }

    public static Method getServiceMethod(Class<?> serviceType, String methodName, Class<?>[] parameterTypes) {
        String finalStr;
        Method method;
        ConcurrentHashMap<String, Method> newMethodMap;
        ConcurrentHashMap<String, Method> methodMap;
        StringBuilder oriStr = new StringBuilder(methodName);
        if (parameterTypes != null) {
            for (Class<?> paramType : parameterTypes) {
                oriStr.append(paramType.getName());
            }
        }
        if ((methodMap = (ConcurrentHashMap<String, Method>)methodCache.get(serviceType)) == null && (methodMap = (ConcurrentMap)methodCache.putIfAbsent(serviceType, newMethodMap = new ConcurrentHashMap<String, Method>())) == null) {
            methodMap = newMethodMap;
        }
        if ((method = (Method)methodMap.get(finalStr = oriStr.toString())) == null) {
            try {
                Method newMethod = serviceType.getMethod(methodName, parameterTypes);
                method = methodMap.putIfAbsent(finalStr, newMethod);
                if (method == null) {
                    method = newMethod;
                }
            }
            catch (Exception e) {
                logger.error("find method {} of type {} fail -> {}", new Object[]{methodName, serviceType, e});
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                String errorMessage = "(" + e.getClass().getName() + ") - " + e.getMessage();
                throw new RsfException(errorMessage, (Throwable)e);
            }
        }
        return method;
    }

    public static Class<?> getType(String typeName, ClassLoader classLoader) {
        Class<?> type = (Class<?>)classCache.get(typeName);
        if (type == null) {
            try {
                Class<?> newType = RsfRuntimeUtils.toJavaType(typeName, classLoader);
                type = classCache.putIfAbsent(typeName, newType);
                if (type == null) {
                    type = newType;
                }
            }
            catch (Throwable e) {
                logger.error("find of type {} fail -> {}", (Object)typeName, (Object)e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                String errorMessage = "(" + e.getClass().getName() + ") - " + e.getMessage();
                throw new RsfException(errorMessage, e);
            }
        }
        return type;
    }
}

