/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.hasor.core.info.CustomerProvider;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.address.RouteTypeEnum;
import net.hasor.rsf.container.FilterDefine;
import net.hasor.rsf.container.RsfDomainProvider;
import net.hasor.rsf.domain.ServiceDomain;
import net.hasor.rsf.domain.warp.RsfBindInfoWrap;
import net.hasor.utils.StringUtils;

class ServiceDefine<T>
extends RsfBindInfoWrap<T>
implements CustomerProvider<T>,
RsfBindInfo<T>,
RsfDomainProvider<T> {
    private final List<FilterDefine> filterList = new ArrayList<FilterDefine>();
    private Supplier<? extends T> customerProvider;
    private String oriFlowControl;
    private final Map<RouteTypeEnum, String> oriRouteScript = new HashMap<RouteTypeEnum, String>();
    private final Set<InterAddress> oriAddressSet = new HashSet<InterAddress>();

    public ServiceDefine(Class<T> bindType) {
        this(new ServiceDomain<T>(Objects.requireNonNull(bindType)));
    }

    public ServiceDefine(ServiceDomain<T> domain) {
        super(Objects.requireNonNull(domain));
    }

    public void addRsfFilter(FilterDefine filterDefine) {
        Objects.requireNonNull(filterDefine.filterID());
        for (FilterDefine filterDef : this.filterList) {
            String defFilterID = filterDef.filterID();
            String filterID = filterDefine.filterID();
            if (!filterID.equals(defFilterID)) continue;
            return;
        }
        this.filterList.add(filterDefine);
    }

    public List<FilterDefine> getFilterSnapshots() {
        return Collections.unmodifiableList(this.filterList);
    }

    public Supplier<? extends T> getCustomerProvider() {
        return this.customerProvider;
    }

    public void setCustomerProvider(Supplier<? extends T> customerProvider) {
        this.customerProvider = customerProvider;
    }

    public void addAddress(InterAddress rsfAddress) {
        this.oriAddressSet.add(Objects.requireNonNull(rsfAddress));
    }

    public Set<InterAddress> getAddressSet() {
        return Collections.unmodifiableSet(this.oriAddressSet);
    }

    public String getFlowControl() {
        return this.oriFlowControl;
    }

    public void setFlowControl(String oriFlowControl) {
        this.oriFlowControl = oriFlowControl;
    }

    public void setRouteScript(RouteTypeEnum routeType, String scriptBody) {
        if (routeType == null || StringUtils.isBlank((String)scriptBody)) {
            return;
        }
        this.oriRouteScript.put(routeType, scriptBody);
    }

    public Map<RouteTypeEnum, String> getRouteScript() {
        return Collections.unmodifiableMap(this.oriRouteScript);
    }

    @Override
    public ServiceDomain<T> getDomain() {
        return (ServiceDomain)this.getTarget();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("");
        List<FilterDefine> defines = this.filterList;
        if (defines == null) {
            buffer.append(" null");
        } else {
            for (FilterDefine define : defines) {
                buffer.append(define.filterID());
                buffer.append(",");
            }
        }
        return "ServiceDefine[Domain=" + this.getTarget() + ",Filters=" + buffer.toString() + "]";
    }
}

