/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.container;

import java.io.IOException;
import java.util.List;
import net.hasor.core.ApiBinder;
import net.hasor.core.BindInfo;
import net.hasor.core.Environment;
import net.hasor.core.binder.ApiBinderCreator;
import net.hasor.rsf.RsfApiBinder;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.container.InnerRsfApiBinder;
import net.hasor.rsf.rpc.context.DefaultRsfEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsfApiBinerCreator
implements ApiBinderCreator<RsfApiBinder> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public RsfApiBinder createBinder(ApiBinder apiBinder) throws IOException {
        Environment env = apiBinder.getEnvironment();
        boolean enable = env.getSettings().getBoolean("hasor.rsfConfig.enable", Boolean.valueOf(false));
        if (!enable) {
            this.logger.info("rsf framework disable -> 'hasor.rsfConfig.enable' is false");
            return null;
        }
        RsfEnvironment rsfEnvironment = this.initAntGetEnvironment(apiBinder);
        return new InnerRsfApiBinder(apiBinder, rsfEnvironment);
    }

    private RsfEnvironment initAntGetEnvironment(ApiBinder apiBinder) throws IOException {
        List rsfEnvList = apiBinder.findBindingRegister(RsfEnvironment.class);
        RsfEnvironment rsfEnv = null;
        if (rsfEnvList != null && !rsfEnvList.isEmpty()) {
            for (BindInfo info : rsfEnvList) {
                rsfEnv = (RsfEnvironment)info.getMetaData(RsfEnvironment.class.getName());
                if (rsfEnv == null) continue;
                return rsfEnv;
            }
        }
        rsfEnv = new DefaultRsfEnvironment(apiBinder.getEnvironment());
        BindInfo info = apiBinder.bindType(RsfEnvironment.class).toInstance((Object)rsfEnv).toInfo();
        info.setMetaData(RsfEnvironment.class.getName(), (Object)rsfEnv);
        return rsfEnv;
    }
}

