/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.container;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.function.Supplier;
import net.hasor.core.BindInfo;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfFilter;
import net.hasor.rsf.RsfPublisher;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.address.RouteTypeEnum;
import net.hasor.rsf.container.AnnoRsfServiceValue;
import net.hasor.rsf.container.FilterDefine;
import net.hasor.rsf.container.ServiceDefine;
import net.hasor.rsf.domain.RsfServiceType;
import net.hasor.rsf.domain.ServiceDomain;
import net.hasor.utils.StringUtils;

abstract class AbstractRsfBindBuilder
implements RsfPublisher {
    AbstractRsfBindBuilder() {
    }

    protected abstract <T> Supplier<? extends T> toProvider(BindInfo<T> var1);

    protected abstract <T> Supplier<? extends T> toProvider(Class<T> var1);

    protected abstract <T> RsfBindInfo<T> addService(ServiceDefine<T> var1);

    protected abstract void addShareFilter(FilterDefine var1);

    @Override
    public RsfPublisher bindFilter(String filterID, RsfFilter instance) {
        return this.bindFilter(filterID, InstanceProvider.of((Object)instance));
    }

    @Override
    public RsfPublisher bindFilter(String filterID, BindInfo<RsfFilter> filterBindInfo) {
        return this.bindFilter(filterID, this.toProvider(filterBindInfo));
    }

    @Override
    public RsfPublisher bindFilter(String filterID, Class<? extends RsfFilter> rsfFilterType) {
        return this.bindFilter(filterID, this.toProvider(rsfFilterType));
    }

    @Override
    public RsfPublisher bindFilter(String filterID, Supplier<? extends RsfFilter> provider) {
        this.addShareFilter(new FilterDefine(filterID, provider));
        return this;
    }

    @Override
    public <T> RsfPublisher.LinkedBuilder<T> rsfService(Class<T> type) {
        return new LinkedBuilderImpl<T>(type);
    }

    @Override
    public <T> RsfPublisher.ConfigurationBuilder<T> rsfService(Class<T> type, T instance) {
        return this.rsfService(type).toInstance(instance);
    }

    @Override
    public <T> RsfPublisher.ConfigurationBuilder<T> rsfService(Class<T> type, Class<? extends T> implementation) {
        return this.rsfService(type).to(implementation);
    }

    @Override
    public <T> RsfPublisher.ConfigurationBuilder<T> rsfService(Class<T> type, Supplier<T> provider) {
        return this.rsfService(type).toProvider(provider);
    }

    @Override
    public <T> RsfPublisher.ConfigurationBuilder<T> rsfService(Class<T> type, BindInfo<T> bindInfo) {
        return this.rsfService(type).toInfo(bindInfo);
    }

    private class LinkedBuilderImpl<T>
    implements RsfPublisher.LinkedBuilder<T> {
        private final ServiceDefine<T> serviceDefine;

        protected LinkedBuilderImpl(Class<T> serviceType) {
            this.serviceDefine = new ServiceDefine<T>(serviceType);
            RsfSettings settings = AbstractRsfBindBuilder.this.getEnvironment().getSettings();
            AnnoRsfServiceValue serviceInfo = new AnnoRsfServiceValue(settings, serviceType);
            ServiceDomain<T> domain = this.serviceDefine.getDomain();
            domain.setServiceType(RsfServiceType.Consumer);
            domain.setBindGroup(serviceInfo.group());
            domain.setBindName(serviceInfo.name());
            domain.setBindVersion(serviceInfo.version());
            domain.setSerializeType(serviceInfo.serializeType());
            domain.setClientTimeout(serviceInfo.clientTimeout());
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> group(String group) {
            Objects.requireNonNull(group, "group is null.");
            if (group.contains("/")) {
                throw new IllegalStateException(group + " contain '/'");
            }
            this.serviceDefine.getDomain().setBindGroup(group);
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> name(String name) {
            Objects.requireNonNull(name, "name is null.");
            if (name.contains("/")) {
                throw new IllegalStateException(name + " contain '/'");
            }
            this.serviceDefine.getDomain().setBindName(name);
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> aliasName(String aliasType, String aliasName) {
            aliasType = Objects.requireNonNull(aliasType, "aliasType is null.");
            aliasName = Objects.requireNonNull(aliasName, "aliasName is null.");
            this.serviceDefine.getDomain().putAliasName(aliasType, aliasName);
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> version(String version) {
            Objects.requireNonNull(version, "version is null.");
            if (version.contains("/")) {
                throw new IllegalStateException(version + " contain '/'");
            }
            this.serviceDefine.getDomain().setBindVersion(version);
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> timeout(int clientTimeout) {
            if (clientTimeout < 1) {
                throw new IllegalStateException("clientTimeout must be greater than 0");
            }
            this.serviceDefine.getDomain().setClientTimeout(clientTimeout);
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> serialize(String serializeType) {
            Objects.requireNonNull(serializeType, "serializeType is null.");
            if (serializeType.contains("/")) {
                throw new IllegalStateException(serializeType + " contain '/'");
            }
            this.serviceDefine.getDomain().setSerializeType(serializeType);
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> protocol(String protocol, String ... protocolArrays) {
            if (StringUtils.isNotBlank((String)protocol)) {
                this.serviceDefine.getDomain().addBindProtocol(protocol);
            }
            for (String prot : protocolArrays) {
                if (!StringUtils.isNotBlank((String)prot)) continue;
                this.serviceDefine.getDomain().addBindProtocol(prot);
            }
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> bindFilter(String filterID, RsfFilter instance) {
            InstanceProvider provider = new InstanceProvider((Object)Objects.requireNonNull(instance));
            this.serviceDefine.addRsfFilter(new FilterDefine(filterID, (Supplier<? extends RsfFilter>)provider));
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> bindFilter(String filterID, Supplier<? extends RsfFilter> provider) {
            this.serviceDefine.addRsfFilter(new FilterDefine(filterID, Objects.requireNonNull(provider)));
            return this;
        }

        @Override
        public RsfPublisher.FilterBindBuilder<T> bindFilter(String filterID, Class<? extends RsfFilter> rsfFilterType) {
            Supplier<? extends RsfFilter> provider = AbstractRsfBindBuilder.this.toProvider(rsfFilterType);
            this.serviceDefine.addRsfFilter(new FilterDefine(filterID, provider));
            return this;
        }

        @Override
        public RsfPublisher.FilterBindBuilder<T> bindFilter(String filterID, BindInfo<RsfFilter> rsfFilterInfo) {
            Supplier<RsfFilter> provider = AbstractRsfBindBuilder.this.toProvider(rsfFilterInfo);
            this.serviceDefine.addRsfFilter(new FilterDefine(filterID, provider));
            return this;
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> to(Class<? extends T> implementation) {
            return this.toProvider(AbstractRsfBindBuilder.this.toProvider(implementation));
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> toInfo(BindInfo<? extends T> bindInfo) {
            return this.toProvider(AbstractRsfBindBuilder.this.toProvider(bindInfo));
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> toInstance(T instance) {
            return this.toProvider((Supplier<? extends T>)new InstanceProvider(instance));
        }

        @Override
        public RsfPublisher.ConfigurationBuilder<T> toProvider(Supplier<? extends T> provider) {
            this.serviceDefine.getDomain().setServiceType(RsfServiceType.Provider);
            this.serviceDefine.setCustomerProvider(provider);
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder<T> bindAddress(String rsfHost, int port) throws UnknownHostException {
            String unitName = AbstractRsfBindBuilder.this.getEnvironment().getSettings().getUnitName();
            return this.bindAddress(new InterAddress(rsfHost, port, unitName), new InterAddress[0]);
        }

        @Override
        public RsfPublisher.RegisterBuilder<T> bindAddress(String rsfURI, String ... array) throws URISyntaxException, UnknownHostException {
            if (!StringUtils.isBlank((String)rsfURI)) {
                this.bindAddress(new InterAddress(rsfURI), new InterAddress[0]);
            }
            if (array.length > 0) {
                for (String bindItem : array) {
                    this.bindAddress(new InterAddress(bindItem), new InterAddress[0]);
                }
            }
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder<T> bindAddress(URI rsfURI, URI ... array) throws UnknownHostException {
            URI[] uRIArray;
            int n;
            int n2;
            if (rsfURI != null && InterAddress.checkFormat(rsfURI)) {
                this.bindAddress(new InterAddress(rsfURI), new InterAddress[0]);
            }
            if (array.length > 0 && (n2 = 0) < (n = (uRIArray = array).length)) {
                URI bindItem = uRIArray[n2];
                if (rsfURI != null && InterAddress.checkFormat(bindItem)) {
                    this.bindAddress(new InterAddress(bindItem), new InterAddress[0]);
                }
                throw new IllegalStateException(bindItem + " check fail.");
            }
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder<T> bindAddress(InterAddress rsfAddress, InterAddress ... array) {
            if (rsfAddress != null) {
                this.serviceDefine.addAddress(rsfAddress);
            }
            if (array.length > 0) {
                for (InterAddress bindItem : array) {
                    if (bindItem == null) continue;
                    this.serviceDefine.addAddress(bindItem);
                }
            }
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder<T> asAloneThreadPool() {
            this.serviceDefine.getDomain().setSharedThreadPool(false);
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder<T> asMessage() {
            this.serviceDefine.getDomain().setMessage(true);
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder<T> asShadow() {
            this.serviceDefine.getDomain().setShadow(true);
            return this;
        }

        @Override
        public RsfBindInfo<T> register() {
            return AbstractRsfBindBuilder.this.addService(this.serviceDefine);
        }

        @Override
        public RsfPublisher.RegisterBuilder updateFlowControl(String flowControl) {
            this.serviceDefine.setFlowControl(flowControl);
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder updateArgsRoute(String scriptBody) {
            this.serviceDefine.setRouteScript(RouteTypeEnum.ArgsLevel, scriptBody);
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder updateMethodRoute(String scriptBody) {
            this.serviceDefine.setRouteScript(RouteTypeEnum.MethodLevel, scriptBody);
            return this;
        }

        @Override
        public RsfPublisher.RegisterBuilder updateServiceRoute(String scriptBody) {
            this.serviceDefine.setRouteScript(RouteTypeEnum.ServiceLevel, scriptBody);
            return this;
        }
    }
}

