/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address.route.flowcontrol.speed;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.hasor.core.Settings;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.address.route.flowcontrol.speed.QoSActionEnum;
import net.hasor.rsf.address.route.flowcontrol.speed.QoSBucket;
import net.hasor.rsf.address.route.rule.AbstractRule;

public class SpeedFlowControl
extends AbstractRule {
    private QoSActionEnum action;
    private int rate = 20;
    private int peak = 200;
    private int timeWindow = 10;
    private QoSBucket defaultQoSBucket;
    private ConcurrentMap<String, QoSBucket> qosBucketMap;

    @Override
    public void parseControl(Settings settings) {
        this.enable(settings.getBoolean("flowControl.enable"));
        this.action = (QoSActionEnum)settings.getEnum("flowControl.action", QoSActionEnum.class);
        this.rate = settings.getInteger("flowControl.rate");
        this.peak = settings.getInteger("flowControl.peak");
        this.timeWindow = settings.getInteger("flowControl.timeWindow");
        this.qosBucketMap = new ConcurrentHashMap<String, QoSBucket>();
        if (this.action == null) {
            this.enable(false);
            this.logger.info("action fail. config is null.");
        }
        if (!this.enable()) {
            return;
        }
        this.logger.info("init default QoS.");
        QoSBucket qosBucket = this.createQoSBucket();
        if (!qosBucket.validate()) {
            this.enable(false);
            this.logger.info("QoS config validate fail. -> %s", (Object)this.defaultQoSBucket);
            return;
        }
        this.defaultQoSBucket = qosBucket;
    }

    public boolean callCheck(String serviceID, String methodName, InterAddress doCallAddress) {
        if (!this.enable()) {
            return true;
        }
        String key = null;
        switch (this.action) {
            case Address: {
                key = doCallAddress.toString();
                break;
            }
            case Method: {
                key = methodName;
                break;
            }
            case Service: {
                key = serviceID;
            }
        }
        if (key == null) {
            return true;
        }
        QoSBucket qos = (QoSBucket)this.qosBucketMap.get(key);
        if (qos == null) {
            qos = this.qosBucketMap.putIfAbsent(key, this.createQoSBucket());
            qos = (QoSBucket)this.qosBucketMap.get(key);
        }
        return qos.check();
    }

    protected QoSBucket createQoSBucket() {
        QoSBucket qosBucket = new QoSBucket(this.rate, this.peak, this.timeWindow);
        this.logger.info("create {}", (Object)qosBucket);
        return qosBucket;
    }

    public static SpeedFlowControl defaultControl(RsfEnvironment rsfEnvironment) {
        SpeedFlowControl flowControl = new SpeedFlowControl();
        RsfSettings rsfSettings = rsfEnvironment.getSettings();
        flowControl.action = (QoSActionEnum)rsfSettings.getEnum("hasor.rsfConfig.defaultSpeedFlowControl.action", QoSActionEnum.class);
        flowControl.rate = rsfSettings.getInteger("hasor.rsfConfig.defaultSpeedFlowControl.rate");
        flowControl.peak = rsfSettings.getInteger("hasor.rsfConfig.defaultSpeedFlowControl.peak");
        flowControl.timeWindow = rsfSettings.getInteger("hasor.rsfConfig.defaultSpeedFlowControl.timeWindow");
        return flowControl;
    }
}

