/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address;

import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptException;
import net.hasor.rsf.address.RuleGroovyScriptFace;
import net.hasor.rsf.utils.groovy223.GroovyScriptEngineImpl;
import net.hasor.utils.CommonCodeUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InnerRuleEngine {
    protected static final Logger logger = LoggerFactory.getLogger(InnerRuleEngine.class);
    private volatile String ruleScript = null;
    private volatile String signature = null;
    private volatile RuleGroovyScriptFace<?> runScript = null;

    InnerRuleEngine() {
    }

    public boolean isEnable() {
        return this.runScript != null;
    }

    public synchronized boolean update(String ruleScript) {
        if (StringUtils.isBlank((String)ruleScript)) {
            ruleScript = "";
            if (this.ruleScript == null) {
                return false;
            }
        }
        String signature = null;
        try {
            signature = CommonCodeUtils.MD5.getMD5((String)ruleScript);
        }
        catch (Throwable e) {
            logger.error("eval ruleScript signature error ->" + e.getMessage(), e);
            signature = ruleScript;
        }
        if (signature.equalsIgnoreCase(this.signature)) {
            return false;
        }
        try {
            if (StringUtils.isBlank((String)ruleScript)) {
                this.ruleScript = null;
                this.signature = signature;
                return true;
            }
            GroovyScriptEngineImpl engine = new GroovyScriptEngineImpl();
            engine.eval(ruleScript);
            this.runScript = ((Invocable)engine).getInterface(RuleGroovyScriptFace.class);
            logger.info("ruleEngine ruleScript compiler finish.");
            this.ruleScript = ruleScript;
            this.signature = signature;
            return true;
        }
        catch (Throwable e) {
            if (e instanceof ScriptException) {
                ScriptException se = (ScriptException)e;
                logger.error("ruleEngine ruleScript compiler error ->at line: " + se.getLineNumber() + " , column: " + se.getColumnNumber() + " , message:" + e.getMessage(), e);
            } else {
                logger.error("ruleEngine ruleScript compiler error ->" + e.getMessage(), e);
            }
            return false;
        }
    }

    public String getScript() {
        return this.ruleScript;
    }

    public Object runRule(String serviceID, List<String> allAddress) {
        if (this.runScript == null) {
            return null;
        }
        try {
            Object result = this.runScript.evalAddress(serviceID, allAddress);
            return result;
        }
        catch (Throwable e) {
            logger.error("evalServiceLevel error ,message = " + e.getMessage(), e);
            return null;
        }
    }
}

